/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot.swing.tile;

import com.macrofocus.cartoplot.swing.tile.SwingTileFactory;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;

class SwingTileCache {
    private final Map<URI, BufferedImage> imgmap = new WeakHashMap<URI, BufferedImage>();
    private final LinkedList<URI> imgmapAccessQueue = new LinkedList();
    private int imagesize = 0;
    private final Map<URI, byte[]> bytemap = new HashMap<URI, byte[]>();
    private final LinkedList<URI> bytemapAccessQueue = new LinkedList();
    private int bytesize = 0;
    private final SwingTileFactory tileFactory;

    SwingTileCache(SwingTileFactory tileFactory) {
        this.tileFactory = tileFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(URI uri, byte[] bimg, BufferedImage img) {
        Map<URI, byte[]> map = this.bytemap;
        synchronized (map) {
            while (this.bytesize > 50000000) {
                URI olduri = this.bytemapAccessQueue.removeFirst();
                byte[] oldbimg = this.bytemap.remove(olduri);
                this.bytesize -= oldbimg.length;
            }
            this.bytemap.put(uri, bimg);
            this.bytesize += bimg.length;
            this.bytemapAccessQueue.addLast(uri);
        }
        this.addToImageCache(uri, img);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage get(URI uri) throws IOException {
        Map<URI, BufferedImage> map = this.imgmap;
        synchronized (map) {
            if (this.imgmap.containsKey(uri)) {
                this.imgmapAccessQueue.remove(uri);
                this.imgmapAccessQueue.addLast(uri);
                return this.imgmap.get(uri);
            }
        }
        map = this.bytemap;
        synchronized (map) {
            if (this.bytemap.containsKey(uri)) {
                this.bytemapAccessQueue.remove(uri);
                this.bytemapAccessQueue.addLast(uri);
                BufferedImage img = this.tileFactory.createImage(this.bytemap.get(uri));
                this.addToImageCache(uri, img);
                return img;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void needMoreMemory() {
        Map<URI, BufferedImage> map = this.imgmap;
        synchronized (map) {
            this.imgmap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<URI, BufferedImage> map = this.imgmap;
        synchronized (map) {
            this.imgmap.clear();
            this.imagesize = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToImageCache(URI uri, BufferedImage img) {
        Map<URI, BufferedImage> map = this.imgmap;
        synchronized (map) {
            try {
                while (this.imagesize > 50000000) {
                    URI olduri = this.imgmapAccessQueue.removeFirst();
                    BufferedImage oldimg = this.imgmap.remove(olduri);
                    if (oldimg == null) continue;
                    this.imagesize -= oldimg.getWidth() * oldimg.getHeight() * 4;
                }
                this.imgmap.put(uri, img);
                this.imagesize += img.getWidth() * img.getHeight() * 4;
                this.imgmapAccessQueue.addLast(uri);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

