/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.originalfastvoronoi;

import com.macrofocus.geom.Rectangle;
import com.treemap.swing.originalfastvoronoi.VoroCellObject;
import com.treemap.swing.originalfastvoronoi.VoronoiCore;
import com.treemap.swing.originalfastvoronoi.VoronoiTreemap;
import com.treemap.swing.originalfastvoronoi.j2d.Point2D;
import com.treemap.swing.originalfastvoronoi.j2d.PolygonSimple;
import com.treemap.swing.originalfastvoronoi.j2d.Site;
import java.util.ArrayList;

public class VoroNode
implements VoroCellObject {
    private VoronoiTreemap treemap;
    private VoroNode parent;
    private ArrayList<VoroNode> children;
    private Integer nodeID;
    private int height = 0;
    private PolygonSimple polygon;
    private boolean toConsider = true;
    private double weight = 1.0;
    private VoronoiCore core;
    private Site site;
    private double wantedPercentage = 0.0;
    private Point2D relativeVector;

    public VoroNode(int nodeID) {
        this.nodeID = nodeID;
    }

    public VoroNode(int nodeID, int numberChildren) {
        this(nodeID);
        this.children = new ArrayList(numberChildren);
    }

    public void calculateWeights() {
        if (this.children == null || this.children.size() == 0) {
            return;
        }
        double sum = 0.0;
        for (VoroNode child : this.children) {
            child.calculateWeights();
            sum += child.getWeight();
        }
        for (VoroNode child : this.children) {
            child.setWantedPercentage(child.getWeight() / sum);
        }
        this.weight = sum;
    }

    public void setNodeID(int nodeID) {
        this.nodeID = nodeID;
    }

    public int getNodeID() {
        return this.nodeID;
    }

    public void setParent(VoroNode parent) {
        this.parent = parent;
    }

    public VoroNode getParent() {
        return this.parent;
    }

    public void setChildren(ArrayList<VoroNode> children) {
        this.children = children;
    }

    public ArrayList<VoroNode> getChildren() {
        return this.children;
    }

    public void setPolygon(PolygonSimple polygon) {
        this.polygon = polygon;
    }

    public PolygonSimple getPolygon() {
        return this.polygon;
    }

    public void setToConsider(boolean toConsider) {
        this.toConsider = toConsider;
    }

    public boolean isToConsider() {
        return this.toConsider;
    }

    public void setWantedPercentage(double percentage) {
        this.weight = percentage;
        this.wantedPercentage = percentage;
        if (this.site != null) {
            this.site.setPercentage(percentage);
        }
    }

    public double getWantedPercentage() {
        return this.wantedPercentage;
    }

    public void addChild(VoroNode child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
        child.parent = this;
        child.treemap = this.treemap;
        child.height = this.height + 1;
    }

    public void iterate() {
        if (this.children == null || this.children.size() == 0) {
            return;
        }
        if (this.site != null) {
            this.polygon = this.site.getPolygon();
        }
        this.scaleRelativeVectors();
        if (this.core == null) {
            this.core = new VoronoiCore(this.polygon);
            this.setSettingsToCore();
            for (VoroNode child : this.children) {
                Point2D p = this.polygon.getRelativePosition(child.relativeVector);
                Site s = new Site(p.getX(), p.getY());
                s.setPercentage(child.wantedPercentage);
                s.setData(child);
                this.core.addSite(s);
                child.setSite(s);
                s.cellObject = child;
            }
        } else {
            this.core = new VoronoiCore(this.polygon);
            this.setSettingsToCore();
            for (VoroNode child : this.children) {
                if (!(child.getWantedPercentage() > 0.0)) continue;
                Point2D pos = null;
                pos = child.relativeVector != null ? this.polygon.getRelativePosition(child.relativeVector) : this.polygon.getInnerPoint();
                child.site.setXY(pos.getX(), pos.getY());
                this.core.addSite(child.site);
            }
        }
        this.core.doIterate();
        if (this.treemap.getUseBorder()) {
            double shrinkPercentage = this.treemap.getShrinkPercentage();
            int length = this.core.getSites().size;
            Site[] sites = this.core.getSites().array;
            for (int i = 0; i < length; ++i) {
                Site s = sites[i];
                s.getPolygon().shrinkForBorder(shrinkPercentage);
            }
        }
    }

    public void scaleRelativeVectors() {
        if (this.getChildren() == null) {
            return;
        }
        if (this.getChildren().size() == 1) {
            VoroNode child = this.getChildren().get(0);
            child.setRelativeVector(this.polygon.getInnerPoint());
            return;
        }
        Rectangle bounds = this.polygon.getBounds();
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        double localCenterX = 0.0;
        double localCenterY = 0.0;
        for (VoroNode child : this.getChildren()) {
            Point2D pos = child.getRelativeVector();
            if (pos == null) {
                pos = this.polygon.getInnerPoint();
            }
            localCenterX += pos.getX();
            localCenterY += pos.getY();
            if (pos.getX() < minX) {
                minX = pos.getX();
            }
            if (pos.getX() > maxX) {
                maxX = pos.getX();
            }
            if (pos.getY() < minY) {
                minY = pos.getY();
            }
            if (!(pos.getY() > maxY)) continue;
            maxY = pos.getY();
        }
        localCenterX /= (double)this.getChildren().size();
        localCenterY /= (double)this.getChildren().size();
        double scaleX = bounds.getWidth() / (maxX - minX) * 0.9;
        double scaleY = bounds.getHeight() / (maxY - minY) * 0.9;
        double centerX = bounds.getCenterX();
        double centerY = bounds.getCenterY();
        for (VoroNode child : this.getChildren()) {
            Point2D pos = child.getRelativeVector();
            pos.setLocation((pos.getX() - localCenterX) * scaleX, (pos.getY() - localCenterY) * scaleY);
        }
    }

    private void setSettingsToCore() {
        this.core.setPreflowPercentage(this.treemap.getPreflowPercentage());
        this.core.setPreflowIncrease(this.treemap.getPreflowIncrease());
        this.core.setUseExtrapolation(this.treemap.getUseExtrapolation());
        this.core.setCancelOnAreaErrorThreshold(this.treemap.getCancelOnThreshold());
        this.core.setErrorAreaThreshold(this.treemap.getCancelErrorThreshold());
        this.core.setCancelOnMaxIterat(this.treemap.getCancelOnMaxIteration());
        this.core.setGuaranteeValidCells(this.treemap.getGuaranteeValidCells());
        this.core.setNumberMaxIterations(this.treemap.getNumberMaxIterations());
        this.core.setUseNegativeWeights(this.treemap.isUseNegativeWeights());
        this.core.setAggressiveMode(this.treemap.getAggressiveMode());
    }

    public void increasePercentageDirectly() {
        this.weight *= 1.5;
    }

    public void decreasePercentage() {
        this.site.setPercentage(this.site.getPercentage() * 0.4);
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setSite(Site s) {
        this.site = s;
    }

    public Site getSite() {
        return this.site;
    }

    public void setTreemap(VoronoiTreemap treemap) {
        this.treemap = treemap;
    }

    public VoronoiTreemap getTreemap() {
        return this.treemap;
    }

    public void setRelativeVector(Point2D relativeVector) {
        this.relativeVector = relativeVector;
    }

    public Point2D getRelativeVector() {
        return this.relativeVector;
    }

    @Override
    public void doFinalWork() {
    }

    @Override
    public void setVoroPolygon(PolygonSimple polygon) {
        this.polygon = polygon;
    }

    public int[] getChildrenIDs() {
        int length;
        if (this.children == null || (length = this.children.size()) == 0) {
            return null;
        }
        int[] ids = new int[length];
        int i = 0;
        for (VoroNode node : this.children) {
            ids[i] = node.getNodeID();
            ++i;
        }
        return ids;
    }

    public PolygonSimple[] getChildrenPolygons() {
        int length;
        if (this.children == null || (length = this.children.size()) == 0) {
            return null;
        }
        PolygonSimple[] polygons = new PolygonSimple[length];
        int i = 0;
        for (VoroNode node : this.children) {
            polygons[i] = node.getSite().getPolygon();
            ++i;
        }
        return polygons;
    }
}

