/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.venn;

import edu.uic.ncdm.venn.VennDiagram;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.LineMetrics;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.JComponent;

public class VennView
extends JComponent {
    private final VennDiagram diagram;

    public VennView(VennDiagram diagram) {
        this.diagram = diagram;
    }

    @Override
    protected void paintComponent(Graphics g) {
        double radius;
        int i;
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        Rectangle2D bounds2D = this.getBounds().getBounds2D();
        double size = Math.min(bounds2D.getWidth(), bounds2D.getHeight());
        RectangularShape bounds = null;
        for (i = 0; i < this.diagram.diameters.length; ++i) {
            radius = this.diagram.diameters[i] / 2.0;
            double x = this.diagram.centers[i][0] - radius;
            double y = this.diagram.centers[i][1] - radius;
            Rectangle2D.Double b = new Rectangle2D.Double(x, y, this.diagram.diameters[i], this.diagram.diameters[i]);
            if (bounds == null) {
                bounds = b;
                continue;
            }
            ((Rectangle2D)bounds).add(b);
        }
        for (i = 0; i < this.diagram.diameters.length; ++i) {
            radius = this.diagram.diameters[i] / 2.0;
            double scale = Math.max(bounds.getWidth(), bounds.getHeight());
            double x = (this.diagram.centers[i][0] - radius - bounds.getX()) / scale;
            double y = (this.diagram.centers[i][1] - radius - bounds.getY()) / scale;
            double scaledX = bounds2D.getX() + x * size;
            double scaledY = bounds2D.getY() + y * size;
            double width = this.diagram.diameters[i] * size / scale;
            g2.draw(new Ellipse2D.Double(scaledX, scaledY, width, width));
            LineMetrics lm = g2.getFontMetrics().getLineMetrics(this.diagram.circleLabels[i], g);
            float sw = g2.getFontMetrics().stringWidth(this.diagram.circleLabels[i]);
            g2.drawString(this.diagram.circleLabels[i], (float)scaledX + (float)width / 2.0f - sw / 2.0f, (float)scaledY + (float)width / 2.0f - lm.getHeight() / 2.0f);
        }
    }
}

