/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.voronoi.smoothing;

import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.treemap.MutableTreeMapNode;
import com.treemap.swing.voronoi.Point2i;
import com.treemap.swing.voronoi.VoronoiCell;
import com.treemap.swing.voronoi.VoronoiOutputRaster;
import com.treemap.swing.voronoi.smoothing.CellWithLocation;
import com.treemap.swing.voronoi.smoothing.Vertex;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class CornerDetector {
    public static List<Vertex> detect(VoronoiOutputRaster voronoiOutput, Shape shape) {
        int width = voronoiOutput.getWidth();
        int height = voronoiOutput.getHeight();
        ArrayList<Vertex> vertexes = new ArrayList<Vertex>(100);
        Point2i northPos = new Point2i();
        Point2i northEastPos = new Point2i();
        Point2i centerPos = new Point2i();
        Point2i eastPos = new Point2i();
        Point2i southPos = new Point2i();
        Point2i southEastPos = new Point2i();
        Point2i westPos = new Point2i();
        Point2i southWestPos = new Point2i();
        Point2i northWestPos = new Point2i();
        CellWithLocation north = new CellWithLocation();
        CellWithLocation northEast = new CellWithLocation();
        CellWithLocation center = new CellWithLocation();
        CellWithLocation east = new CellWithLocation();
        CellWithLocation south = new CellWithLocation();
        CellWithLocation southEast = new CellWithLocation();
        CellWithLocation west = new CellWithLocation();
        CellWithLocation southWest = new CellWithLocation();
        CellWithLocation northWest = new CellWithLocation();
        Rectangle domainBounds = voronoiOutput.getDomainBounds();
        for (int x = domainBounds.x; x < domainBounds.x + width; ++x) {
            for (int y = domainBounds.y; y < domainBounds.y + height; ++y) {
                boolean bottom;
                boolean westIsOutside;
                if ((!(shape instanceof Rectangle2D) || !shape.getBounds2D().contains((double)x, (double)y)) && !shape.contains((Point2D)new Point2D.Double((double)x, (double)y))) continue;
                northPos.set(x, y - 1);
                northEastPos.set(x + 1, y - 1);
                centerPos.set(x, y);
                eastPos.set(x + 1, y);
                southPos.set(x, y + 1);
                southEastPos.set(x + 1, y + 1);
                westPos.set(x - 1, y);
                southWestPos.set(x - 1, y + 1);
                northWestPos.set(x - 1, y - 1);
                VoronoiCell northCell = voronoiOutput.get(northPos);
                VoronoiCell northEastCell = voronoiOutput.get(northEastPos);
                VoronoiCell centerCell = voronoiOutput.get(centerPos);
                VoronoiCell eastCell = voronoiOutput.get(eastPos);
                VoronoiCell southCell = voronoiOutput.get(southPos);
                VoronoiCell southEastCell = voronoiOutput.get(southEastPos);
                VoronoiCell westCell = voronoiOutput.get(westPos);
                VoronoiCell southWestCell = voronoiOutput.get(southWestPos);
                VoronoiCell northWestCell = voronoiOutput.get(northWestPos);
                north.set(northCell, northPos);
                northEast.set(northEastCell, northEastPos);
                center.set(centerCell, centerPos);
                east.set(eastCell, eastPos);
                south.set(southCell, southPos);
                southEast.set(southEastCell, southEastPos);
                west.set(westCell, westPos);
                southWest.set(southWestCell, southWestPos);
                northWest.set(northWestCell, northWestPos);
                CornerDetector.findCornerAndIfFoundAdd(vertexes, center, east, south, southEast);
                boolean northIsOutside = northCell == VoronoiCell.outsideDomainCell || northCell == null;
                boolean bl = westIsOutside = westCell == VoronoiCell.outsideDomainCell || westCell == null;
                if (northIsOutside) {
                    CornerDetector.findCornerAndIfFoundAdd(vertexes, north, northEast, center, east);
                }
                if (westIsOutside) {
                    CornerDetector.findCornerAndIfFoundAdd(vertexes, west, center, southWest, south);
                }
                if (northIsOutside && westIsOutside) {
                    CornerDetector.findCornerAndIfFoundAdd(vertexes, northWest, north, west, center);
                }
                if (!(shape instanceof Rectangle2D)) continue;
                Rectangle2D bounds = shape.getBounds2D();
                boolean left = (double)x <= bounds.getX();
                boolean right = (double)x >= bounds.getX() + (double)width - 1.0;
                boolean top = (double)y <= bounds.getY();
                boolean bl2 = bottom = (double)y >= bounds.getY() + (double)height - 1.0;
                if (top && left) {
                    CornerDetector.createAndAddRectangleCorner(vertexes, center, -0.5, -0.5);
                }
                if (top && right) {
                    CornerDetector.createAndAddRectangleCorner(vertexes, center, 1.0, -0.5);
                }
                if (bottom && left) {
                    CornerDetector.createAndAddRectangleCorner(vertexes, center, -0.5, 1.0);
                }
                if (!bottom || !right) continue;
                CornerDetector.createAndAddRectangleCorner(vertexes, center, 1.0, 1.0);
            }
        }
        return vertexes;
    }

    private static void createAndAddRectangleCorner(List<Vertex> vertexes, CellWithLocation center, double x, double y) {
        Point2i location = center.getLocation();
        boolean touchingParentSpline = false;
        boolean rectangleCorner = true;
        boolean vertexOfParentSegment = false;
        Vertex vertex = new Vertex((double)location.x + x, (double)location.y + y, false, true, false);
        vertex.addAdjacentCellPixel(center);
        vertex.addAdjacentCellPixel(center.getCell(), location.x + (int)Math.signum(x), location.y + (int)Math.signum(y));
        vertexes.add(vertex);
    }

    private static void findCornerAndIfFoundAdd(List<Vertex> vertexes, CellWithLocation center, CellWithLocation east, CellWithLocation south, CellWithLocation southEast) {
        int outsideCells;
        ArrayList<VoronoiCell> neighbourCells = new ArrayList<VoronoiCell>(9);
        CornerDetector.fillToListEachInstanceOnce(center.getCell(), east.getCell(), south.getCell(), southEast.getCell(), neighbourCells);
        int differentCellsCount = neighbourCells.size();
        if (differentCellsCount >= 3) {
            CornerDetector.createAndAddCorner(neighbourCells, vertexes, center, east, south, southEast);
        }
        if ((outsideCells = CornerDetector.countOutsideCells(center.getCell(), east.getCell(), south.getCell(), southEast.getCell())) == 3) {
            CornerDetector.createAndAddCorner(neighbourCells, vertexes, center, east, south, southEast);
        }
    }

    private static int countOutsideCells(VoronoiCell ... cells) {
        int counter = 0;
        for (VoronoiCell cell : cells) {
            if (cell != VoronoiCell.outsideDomainCell) continue;
            ++counter;
        }
        return counter;
    }

    private static void createAndAddCorner(List<VoronoiCell> neighbourCells, List<Vertex> vertexes, CellWithLocation center, CellWithLocation ... cells) {
        boolean touchesParentSpline = CornerDetector.hasNeighboursOutsideDomain(neighbourCells);
        Point2i centerLocation = center.getLocation();
        Vertex vertex = new Vertex((double)centerLocation.x + 0.5, (double)centerLocation.y + 0.5, touchesParentSpline);
        vertex.addAdjacentCellPixel(center);
        for (CellWithLocation cellWithLocation : cells) {
            vertex.addAdjacentCellPixel(cellWithLocation);
        }
        vertexes.add(vertex);
    }

    private static List<VoronoiCell> fillToListEachInstanceOnce(VoronoiCell center, VoronoiCell east, VoronoiCell south, VoronoiCell southEast, List<VoronoiCell> cells) {
        cells.clear();
        cells.add(center);
        CornerDetector.addIfNotContained(east, cells);
        CornerDetector.addIfNotContained(south, cells);
        CornerDetector.addIfNotContained(southEast, cells);
        return cells;
    }

    private static void addParentIfNotContained(VoronoiCell cell, List<MutableTreeMapNode> neighbourParents) {
        if (cell != null) {
            neighbourParents.add(cell.getParent());
        }
    }

    private static boolean hasNeighboursOutsideDomain(List<VoronoiCell> list) {
        for (VoronoiCell cell : list) {
            if (cell != VoronoiCell.outsideDomainCell) continue;
            return true;
        }
        return false;
    }

    private static <T> void addIfNotContained(T elementToAdd, List<T> list) {
        if (!list.contains(elementToAdd)) {
            list.add(elementToAdd);
        }
    }
}

