/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.voronoi.smoothing;

import com.treemap.swing.voronoi.Point2d;
import com.treemap.swing.voronoi.Vector2d;
import com.treemap.swing.voronoi.smoothing.AbstractSmoothedSegment;
import com.treemap.swing.voronoi.smoothing.LineSegment;
import com.treemap.swing.voronoi.smoothing.SegmentDirection;
import com.treemap.swing.voronoi.smoothing.SegmentLocation;
import com.treemap.swing.voronoi.smoothing.SmoothedSegment;
import com.treemap.swing.voronoi.smoothing.StraightLocation;
import com.treemap.swing.voronoi.smoothing.Vertex;
import java.awt.geom.GeneralPath;

public class LinearSegment
extends AbstractSmoothedSegment {
    private final Vector2d startToEnd = new Vector2d();
    private final Vector2d startToVertex = new Vector2d();
    private final Vector2d endToVertex = new Vector2d();

    public LinearSegment(LineSegment lineSegment, SegmentDirection direction) {
        super(lineSegment, direction);
    }

    public LinearSegment(Vertex startVertex, Vertex endVertex, LineSegment lineSegment) {
        super(startVertex, endVertex, lineSegment);
    }

    @Override
    public void addToGeneralPath(GeneralPath generalPath) {
        if (this.getEndVertex() != null) {
            Point2d endPoint = this.getEndVertex().getLocation();
            generalPath.lineTo(endPoint.x, endPoint.y);
        }
    }

    @Override
    public SmoothedSegment reversed() {
        return new LinearSegment(this.getEndVertex(), this.getStartVertex(), this.getLineSegment());
    }

    @Override
    public SegmentLocation getNearestSegmentLocation(Vertex vertex) {
        double distanceSquared;
        Vertex startVertex = this.getStartVertex();
        Vertex endVertex = this.getEndVertex();
        this.startToEnd.sub(endVertex.getLocation(), startVertex.getLocation());
        this.startToVertex.sub(vertex.getLocation(), startVertex.getLocation());
        double t = this.startToEnd.dot(this.startToVertex);
        if (t <= 0.0) {
            distanceSquared = this.startToVertex.dot(this.startToVertex);
        } else {
            double startToEndSelfDotted = this.startToEnd.dot(this.startToEnd);
            if (t >= startToEndSelfDotted) {
                this.endToVertex.sub(vertex.getLocation(), endVertex.getLocation());
                distanceSquared = this.endToVertex.dot(this.endToVertex);
            } else {
                distanceSquared = this.startToVertex.dot(this.startToVertex) - t * t / startToEndSelfDotted;
            }
        }
        return new StraightLocation(this, distanceSquared, vertex);
    }

    @Override
    public SmoothedSegment getSubSegment(SegmentLocation start, SegmentLocation end) {
        return new LinearSegment(start.getVertex(), end.getVertex(), this.getLineSegment());
    }
}

