/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.ncdm.venn.data;

import edu.uic.ncdm.venn.data.VennData;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class FileReader {
    private static Map separators = new LinkedHashMap();
    private static String separator = " ";
    private static int nCols;
    private static int nRows;
    private static boolean isAreas;
    private static boolean isBinaryMatrix;
    private static String[] labels;

    public static VennData getData(File fname) {
        FileReader.identifySeparator(fname);
        nRows = 0;
        try {
            BufferedReader fin = new BufferedReader(new java.io.FileReader(fname));
            while (fin.readLine() != null) {
                ++nRows;
            }
            fin.close();
            String[][] data = new String[--nRows][nCols];
            double[] areas = new double[nRows];
            fin = new BufferedReader(new java.io.FileReader(fname));
            String record = fin.readLine();
            record = FileReader.compressBlanks(record);
            String[] row = FileReader.split(record);
            labels = new String[nCols];
            System.arraycopy(row, 0, labels, 0, nCols);
            for (int i = 0; i < nRows && (record = fin.readLine()) != null; ++i) {
                record = FileReader.compressBlanks(record);
                row = FileReader.split(record);
                if (i == 0) {
                    if (row.length == 2) {
                        isAreas = FileReader.isDouble(row[1]);
                    } else if (row.length > 2) {
                        isBinaryMatrix = true;
                    }
                }
                if (isAreas) {
                    data[i][0] = row[0];
                    areas[i] = Double.parseDouble(row[1]);
                    continue;
                }
                if (isBinaryMatrix) {
                    System.arraycopy(row, 0, data[i], 0, nCols);
                    continue;
                }
                System.arraycopy(row, 0, data[i], 0, 2);
            }
            fin.close();
            if (isBinaryMatrix) {
                data = FileReader.reformData(data);
            }
            return new VennData(data, areas, isAreas);
        }
        catch (IOException ie) {
            System.err.println("I/O exception in getData");
            return null;
        }
    }

    private static String[][] reformData(String[][] data) {
        ArrayList<String[]> d = new ArrayList<String[]>(nRows);
        for (int i = 0; i < nRows; ++i) {
            for (int j = 0; j < nCols - 1; ++j) {
                data[i][j] = data[i][j].trim();
                if (!data[i][j].equals("1")) continue;
                String[] record = new String[]{labels[j], data[i][nCols - 1]};
                d.add(record);
            }
        }
        String[][] result = new String[d.size()][2];
        for (int i = 0; i < d.size(); ++i) {
            Object[] o = (Object[])d.get(i);
            result[i][0] = (String)o[0];
            result[i][1] = (String)o[1];
        }
        return result;
    }

    private static boolean isDouble(String s) {
        try {
            Double.parseDouble(s);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    private static void identifySeparator(File fname) {
        separators.put(",", new int[2]);
        separators.put(";", new int[2]);
        separators.put(":", new int[2]);
        separators.put("|", new int[2]);
        separators.put("\t", new int[2]);
        separators.put(" ", new int[2]);
        try {
            String record;
            BufferedReader fin = new BufferedReader(new java.io.FileReader(fname));
            int n = 0;
            while ((record = fin.readLine()) != null) {
                if ((record = FileReader.compressBlanks(record)).length() == 0) continue;
                FileReader.countSeparators(record);
                FileReader.deleteInvalidSeparators(n);
                if (++n <= 100 && separators.size() != 0) continue;
            }
            if (separators.size() == 0) {
                if (n == 1) {
                    separator = "";
                    nCols = 1;
                }
            } else {
                Object[] keys = separators.keySet().toArray();
                separator = (String)keys[0];
                nCols = 1 + ((int[])separators.get(separator))[1];
            }
            fin.close();
        }
        catch (IOException ie) {
            System.err.println("I/O exception in computeVariableTypes");
        }
    }

    private static void countSeparators(String record) {
        boolean isUnquoted = true;
        block0: for (int i = 0; i < record.length(); ++i) {
            if (record.charAt(i) == '\"') {
                boolean bl = isUnquoted = !isUnquoted;
            }
            if (!isUnquoted) continue;
            Object[] keys = separators.keySet().toArray();
            for (int j = 0; j < keys.length; ++j) {
                String key = (String)keys[j];
                if (!record.substring(i, i + 1).equals(key)) continue;
                int[] counts = (int[])separators.get(key);
                counts[0] = counts[0] + 1;
                continue block0;
            }
        }
    }

    private static void deleteInvalidSeparators(int n) {
        Object[] keys = separators.keySet().toArray();
        for (int j = 0; j < keys.length; ++j) {
            String key = (String)keys[j];
            int[] counts = (int[])separators.get(key);
            if (counts[0] == 0 || n > 0 && counts[0] != counts[1]) {
                separators.remove(key);
                continue;
            }
            counts[1] = counts[0];
            counts[0] = 0;
            separators.put(key, counts);
        }
    }

    private static String[] split(String record) {
        String[] row = new String[nCols];
        boolean isUnquoted = true;
        int i0 = 0;
        int col = 0;
        for (int i = 0; i < record.length(); ++i) {
            if (record.charAt(i) == '\"') {
                boolean bl = isUnquoted = !isUnquoted;
            }
            if (!isUnquoted) continue;
            if (record.substring(i, i + 1).equals(separator)) {
                row[col] = record.substring(i0, i);
                row[col] = FileReader.trimSpaces(row[col]);
                row[col] = FileReader.trimQuotes(row[col]);
                ++col;
                i0 = i + 1;
                continue;
            }
            if (i != record.length() - 1) continue;
            row[col] = record.substring(i0, i + 1);
            row[col] = FileReader.trimSpaces(row[col]);
            row[col] = FileReader.trimQuotes(row[col]);
        }
        if (row[nCols - 1] == null) {
            row[FileReader.nCols - 1] = "";
        }
        return row;
    }

    private static String trimSpaces(String s) {
        return s.trim();
    }

    private static String trimQuotes(String s) {
        if (s.startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    private static String compressBlanks(String record) {
        return record.replaceAll(" {2,}", " ").trim();
    }
}

