/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Constructor;
import java.text.NumberFormat;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class SyntheticaDefaultTableCellEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = -4003145629974364170L;
    private Constructor<?> constructor;
    private Object value;
    private boolean respectNumberLocale;

    public SyntheticaDefaultTableCellEditor() {
        this(new JTextField());
    }

    public SyntheticaDefaultTableCellEditor(JTextField textField) {
        this(textField, null);
    }

    public SyntheticaDefaultTableCellEditor(JTextField textField, Boolean respectNumberLocale) {
        super(textField);
        this.getComponent().setName("Table.editor");
        this.respectNumberLocale = respectNumberLocale != null ? respectNumberLocale : SyntheticaLookAndFeel.getBoolean("Synthetica.table.cellEditor.respectNumberLocale", null, false);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.value = null;
        JComponent c = (JComponent)this.getComponent();
        c.setBorder(this.createCellFocusBorder(table));
        c.setOpaque(SyntheticaLookAndFeel.getBoolean("Synthetica.table.cellEditor.opaque", table));
        try {
            Class<Object> clazz = table.getColumnClass(column);
            if (this.respectNumberLocale && Number.class.isAssignableFrom(clazz)) {
                value = NumberFormat.getInstance().format(value);
            }
            if (clazz == Object.class) {
                clazz = String.class;
            }
            this.constructor = clazz.getConstructor(String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public boolean stopCellEditing() {
        String s = (String)super.getCellEditorValue();
        if (s != null && s.length() == 0) {
            if (this.constructor.getDeclaringClass() == String.class) {
                this.value = "";
            }
            super.stopCellEditing();
        }
        try {
            if (this.respectNumberLocale && Number.class.isAssignableFrom(this.constructor.getDeclaringClass())) {
                s = "" + NumberFormat.getNumberInstance().parse(s);
            }
            this.value = this.constructor.newInstance(s);
        }
        catch (Exception e) {
            JComponent c = (JComponent)this.getComponent();
            c.setBorder(this.createErrorCellFocusBorder((JTable)c.getParent()));
            return false;
        }
        return super.stopCellEditing();
    }

    protected Border createCellFocusBorder(JTable table) {
        Color defaultFocusColor = SyntheticaLookAndFeel.getColor("Synthetica.table.focusCellHighlightBorder.color", table);
        return new CellFocusBorder(SyntheticaLookAndFeel.getColor("Synthetica.table.cellEditor.focus.color", table, defaultFocusColor));
    }

    protected Border createErrorCellFocusBorder(JTable table) {
        return new CellFocusBorder(SyntheticaLookAndFeel.getColor("Synthetica.table.cellEditor.focus.errorColor", table, new Color(0xE70000)));
    }

    public static class CellFocusBorder
    implements Border {
        private Color color = Color.GRAY;

        public CellFocusBorder(Color color) {
            if (color != null) {
                this.color = color;
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            int borderSize = this.getBorderSize(c);
            if (c.getParent() instanceof JTable) {
                JLabel l = new JLabel();
                l.setName("Table.cellRenderer");
                SynthStyle ss = SynthLookAndFeel.getStyleFactory().getStyle(l, Region.LABEL);
                Insets ins = ss.getInsets(new SynthContext(l, Region.LABEL, ss, 0), null);
                return ins;
            }
            return new Insets(borderSize, borderSize, borderSize, borderSize);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(this.color);
            int borderSize = this.getBorderSize(c);
            int i = 0;
            while (i < borderSize) {
                g2.draw(this.createShape(x + i, y + i, w - i * 2 - 1, h - i * 2 - 1));
                ++i;
            }
        }

        private int getBorderSize(Component c) {
            return SyntheticaLookAndFeel.getInt("Synthetica.table.cellEditor.focus.size", c, 1, true);
        }

        private Shape createShape(float x, float y, float w, float h) {
            return new Rectangle2D.Float(x, y, w, h);
        }
    }

    public static class NumberEditor
    extends SyntheticaDefaultTableCellEditor {
        private static final long serialVersionUID = 966057265129092767L;

        public NumberEditor() {
            ((JTextField)this.getComponent()).setHorizontalAlignment(4);
        }
    }
}

