/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthSliderUI;

public class SyntheticaSliderUI
extends SynthSliderUI {
    public static ComponentUI createUI(JComponent c) {
        return new SyntheticaSliderUI((JSlider)c);
    }

    protected SyntheticaSliderUI(JSlider slider) {
        super(slider);
    }

    @Override
    protected void installDefaults(JSlider slider) {
        super.installDefaults(slider);
        this.focusInsets = (Insets)UIManager.get("Slider.focusInsets");
        if (this.focusInsets == null) {
            this.focusInsets = SyntheticaLookAndFeel.getInstance().scaleInsets(new Insets(0, 0, 0, 0));
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension dim = super.getPreferredSize(c);
        int prefSize = 200;
        int size = SyntheticaLookAndFeel.getInstance().scaleInteger(prefSize);
        int width = dim.width;
        int height = dim.height;
        if (this.slider.getOrientation() == 0) {
            width = dim.width - prefSize + size;
            height += SyntheticaLookAndFeel.getInstance().scaleInteger(4) - 4;
        } else {
            width += SyntheticaLookAndFeel.getInstance().scaleInteger(4) - 4;
            height = dim.height - prefSize + size;
        }
        return new Dimension(width, height);
    }

    @Override
    protected void calculateGeometry() {
        this.calculateFocusRect();
        this.calculateContentRect();
        this.calculateThumbSize();
        this.calculateTrackBuffer();
        this.calculateTrackRect();
        this.calculateTickRect();
        this.calculateLabelRect();
        this.calculateThumbLocation();
        super.calculateGeometry();
        Insets insets = this.slider.getInsets();
        float scaleFactor = SyntheticaLookAndFeel.getInstance().getScaleFactor();
        float scaleFactor2 = Math.max(0.0f, scaleFactor - 1.0f);
        if (this.slider.getOrientation() == 0) {
            int corr = Math.round((float)insets.top / scaleFactor);
            int corr2 = corr + 2;
            this.tickRect.y = (int)((float)this.tickRect.y + (float)corr * scaleFactor2);
            this.labelRect.y = (int)((float)this.labelRect.y + (float)corr2 * scaleFactor2);
            this.contentRect.height = (int)((float)this.contentRect.height + (float)corr * scaleFactor2);
        } else {
            int corr = Math.round((float)insets.left / scaleFactor);
            int corr2 = corr + 2;
            this.tickRect.x = (int)((float)this.tickRect.x + (float)corr * scaleFactor2);
            this.labelRect.x = (int)((float)this.labelRect.x + (float)corr2 * scaleFactor2);
            this.contentRect.width = (int)((float)this.contentRect.width + (float)corr * scaleFactor2);
        }
    }

    @Override
    protected int getTickLength() {
        return SyntheticaLookAndFeel.getInt("Synthetica.slider.tickLength", this.slider, 8, true);
    }

    @Override
    protected void paint(SynthContext sc, Graphics g) {
        super.paint(sc, g);
    }

    @Override
    protected void paintMinorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        int scaleFactor = Math.max(1, (int)SyntheticaLookAndFeel.getInstance().getScaleFactor());
        g.fillRect(x, 0, scaleFactor, tickBounds.height / 2);
    }

    @Override
    protected void paintMajorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        int scaleFactor = Math.max(1, (int)SyntheticaLookAndFeel.getInstance().getScaleFactor());
        g.fillRect(x, 0, scaleFactor, tickBounds.height - scaleFactor);
    }

    @Override
    protected void paintMinorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        int scaleFactor = Math.max(1, (int)SyntheticaLookAndFeel.getInstance().getScaleFactor());
        g.fillRect(0, y, tickBounds.width / 2, scaleFactor);
    }

    @Override
    protected void paintMajorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        int scaleFactor = Math.max(1, (int)SyntheticaLookAndFeel.getInstance().getScaleFactor());
        g.fillRect(0, y, tickBounds.width - scaleFactor, scaleFactor);
    }
}

