/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaPainterState;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.plaf.synth.SynthContext;

public class ArrowButtonPainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.ArrowButtonPainter";

    protected ArrowButtonPainter() {
    }

    public static ArrowButtonPainter getInstance() {
        return ArrowButtonPainter.getInstance(null);
    }

    public static ArrowButtonPainter getInstance(SynthContext sc) {
        SyntheticaComponentPainter instance = (SyntheticaComponentPainter)instances.get(ArrowButtonPainter.getPainterClassName(sc, ArrowButtonPainter.class, UI_KEY));
        if (instance == null) {
            instance = ArrowButtonPainter.getInstance(sc, ArrowButtonPainter.class, UI_KEY);
        }
        return (ArrowButtonPainter)instance;
    }

    public void paintArrowButtonBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintArrowButtonBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        boolean flipHorizontal;
        JButton arrowButton = (JButton)sc.getComponent();
        Container parent = arrowButton.getParent();
        String cName = arrowButton.getName();
        int lockedState = 0;
        if (parent instanceof JComboBox) {
            lockedState = ((JComboBox)parent).isEditable() ? 0 : SyntheticaState.State.LOCKED.toInt();
        }
        SyntheticaPainterState state = new SyntheticaPainterState(sc, lockedState, false);
        if (cName != null && cName.startsWith("SplitPaneDivider.")) {
            return;
        }
        int direction = (Integer)arrowButton.getClientProperty("__arrow_direction__");
        boolean fallback = true;
        boolean bl = flipHorizontal = (direction == 5 || direction == 1) && !arrowButton.getComponentOrientation().isLeftToRight();
        if (parent instanceof JComboBox || cName != null && cName.startsWith("ComboBox.arrowButton")) {
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.comboBox.hoverAndPressed.enabled", parent)) {
                state = new SyntheticaPainterState(sc, lockedState, false, true);
            }
            direction = 7;
        } else if (parent instanceof JSpinner || "Spinner.nextButton".equals(cName) || "Spinner.previousButton".equals(cName)) {
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.spinner.hoverAndPressed.enabled", parent)) {
                state = new SyntheticaPainterState(sc, lockedState, false, false);
            }
            direction = 7;
        }
        Insets sInsets = null;
        UIKey key = new UIKey("arrowButton.y.background", state);
        if (fallback) {
            int threshold = SyntheticaLookAndFeel.getInt("Synthetica.arrowButton.smallSizeThreshold", arrowButton, 12, true);
            if (w <= threshold || h <= threshold) {
                key = new UIKey("arrowButton.8x8.background", state);
            } else if (direction == 3 || direction == 7) {
                key = new UIKey("arrowButton.x.background", state);
            }
            sInsets = (Insets)key.findProperty(sc, "insets", 3);
        }
        String imagePath = key.resolveImagePath(sc, 2);
        Insets dInsets = sInsets;
        int cycles = SyntheticaLookAndFeel.getInt(key.get("animation.cycles"), (Component)arrowButton, 1);
        int delay = SyntheticaLookAndFeel.getInt(key.get("animation.delay"), (Component)arrowButton, 50);
        int type = SyntheticaLookAndFeel.getInt(key.get("animation.type"), (Component)arrowButton, 2);
        if (state.isSet(SyntheticaState.State.HOVER)) {
            type = SyntheticaLookAndFeel.getInt(key.get("animation.type"), (Component)arrowButton, 1);
        }
        ImagePainter imagePainter = new ImagePainter(arrowButton, null, cycles, delay, type, state.getState(), g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0, flipHorizontal, false);
        imagePainter.draw();
    }

    public void paintArrowButtonForeground(SynthContext sc, Graphics g, int x, int y, int w, int h, int direction) {
        int size;
        JComponent c = sc.getComponent();
        SyntheticaPainterState state = new SyntheticaPainterState(sc);
        UIKey key = new UIKey("arrow", state, direction, -1, -1);
        boolean flipHorizontal = (direction == 5 || direction == 1) && !c.getComponentOrientation().isLeftToRight();
        int thres = SyntheticaLookAndFeel.getInstance().scaleInteger(12);
        if (w <= thres || h <= thres) {
            size = SyntheticaLookAndFeel.getInstance().scaleInteger(8);
            key = new UIKey("arrow.8x8", state, direction, -1, -1);
            x += (w - size + 1) / 2;
            y += (h - size + 1) / 2;
            w = size;
            h = size;
        } else if (w != thres || h != thres) {
            size = SyntheticaLookAndFeel.getInstance().scaleInteger(16);
            x += flipHorizontal ? (w - size) / 2 : (w - size + 1) / 2;
            y += (h - size + 1) / 2;
            w = size;
            h = size;
        }
        x += SyntheticaLookAndFeel.getInstance().scaleInteger(c.getClientProperty("Synthetica.arrow.xOffset") == null ? 0 : (Integer)c.getClientProperty("Synthetica.arrow.xOffset")).intValue();
        y += SyntheticaLookAndFeel.getInstance().scaleInteger(c.getClientProperty("Synthetica.arrow.yOffset") == null ? 0 : (Integer)c.getClientProperty("Synthetica.arrow.yOffset")).intValue();
        Insets sInsets = new Insets(0, 0, 0, 0);
        Insets dInsets = new Insets(0, 0, 0, 0);
        String imagePath = this.resolveImagePath(key.get(), c);
        if (imagePath != null) {
            ImagePainter imagePainter = new ImagePainter(c, null, -1, -1, -1, -1, g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0, flipHorizontal, false);
            imagePainter.draw();
        }
    }
}

