/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.clustering;

import com.macrofocus.common.command.Command;
import com.macrofocus.common.logging.Logging;
import com.macrofocus.crossplatform.CPButton;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.CPSplitPanel;
import com.macrofocus.high_d.HighDFactory;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.clustering.Clustering;
import com.macrofocus.high_d.clustering.HighD_Cluster;
import com.macrofocus.high_d.clustering.High_DPoint;
import com.macrofocus.high_d.filters.CategoricalFilterComponent;
import com.macrofocus.molap.subset.SingleBinningDimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.math3.ml.clustering.Cluster;
import org.apache.commons.math3.ml.clustering.KMeansPlusPlusClusterer;

public abstract class AbstractClustering<Component, Color, Row, Column>
implements Clustering<Component, Color, Row, Column> {
    private final CPSplitPanel<Component> nativeComponent;
    private HighDFactory<Component, Color, ?, ?, Row, Column, Object> factory;
    protected SingleBinningDimension<Row, ?> binningDimension;

    public AbstractClustering(final HighDFactory<Component, Color, ?, ?, Row, Column, ?> factory) {
        this.nativeComponent = factory.getCPFactory().createVerticalSplitPanel();
        CPButton createClusters = factory.getCPFactory().createButton("Create Clusters");
        this.nativeComponent.setFirstWidget((CPComponent)createClusters);
        createClusters.setCommand(new Command(){

            public void execute() {
                AbstractClustering.this.binningDimension.filterAll();
                ArrayList values = new ArrayList();
                for (AxisGroupModel group : factory.getAxisHierarchy().getAxisGroupHierarchy().breadthFirstIterator()) {
                    for (Object r : factory.getDataFrame().rows()) {
                        if (factory.getVisual().getFilter().isFiltered(r)) continue;
                        double[] v = new double[group.getAxisOrder().size()];
                        int c = 0;
                        boolean missing = false;
                        for (AxisModel axisModel : group.getAxisOrder()) {
                            Number value = axisModel.getValue(r);
                            if (value != null) {
                                v[c] = axisModel.getNormalized(value.doubleValue());
                            } else {
                                v[c] = Double.NaN;
                                missing = true;
                            }
                            ++c;
                        }
                        if (missing) continue;
                        values.add(new High_DPoint(r, factory.getDataFrame().getRowAddress(r), v));
                    }
                }
                try {
                    List clusters = new KMeansPlusPlusClusterer(Math.min(values.size(), 20)).cluster(values);
                    final HashMap rowCluster = new HashMap();
                    int clusterId = 1;
                    for (Cluster cluster : clusters) {
                        HighD_Cluster highDCluster = new HighD_Cluster(clusterId, cluster);
                        ++clusterId;
                        List points = highDCluster.getCluster().getPoints();
                        for (High_DPoint point : points) {
                            rowCluster.put(point.getRow(), highDCluster);
                        }
                    }
                    AbstractClustering.this.binningDimension.setBinningStrategy(new SingleBinningDimension.SingleBinningStrategy(){

                        public boolean isBinnable(Object o) {
                            return rowCluster.get(o) != null;
                        }

                        public Object rowToBin(Object o) {
                            return rowCluster.get(o);
                        }
                    });
                }
                catch (Exception e1) {
                    Logging.getInstance().process((Throwable)e1);
                }
            }
        });
        if (factory != null && factory.getSubsetDataFrame() != null) {
            this.setModel(factory, factory.getSubsetDataFrame().getBinningDimension((Object)"Clusters", null));
        }
    }

    @Override
    public void setModel(HighDFactory factory, SingleBinningDimension<Row, ?> model) {
        this.factory = factory;
        if (factory != null) {
            this.binningDimension = model;
            CategoricalFilterComponent<Component, Color> filter = this.createCategoricalFilterComponent(factory);
            if (filter != null) {
                filter.getNullLabel().setValue((Object)"Unclustered");
                filter.getOrientation().setValue((Object)CategoricalFilterComponent.Orientation.Horizontal);
                filter.setInteractionMode(factory.getInteractionMode());
                filter.setColorTheme(factory.getColorTheme());
                this.nativeComponent.setLastWidget(filter);
            }
        }
    }

    public abstract CategoricalFilterComponent<Component, Color> createCategoricalFilterComponent(HighDFactory var1);

    @Override
    public Component getNativeComponent() {
        return (Component)this.nativeComponent.getNativeComponent();
    }
}

