/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.mds.quality;

import com.macrofocus.high_d.mds.MDSModel;
import com.macrofocus.molap.dataframe.matrix.Matrix;

public class QualityEngine {
    public static <R> double computeStress(MDSModel map, Matrix<R, R> distanceTable) {
        double squared_distances = 0.0;
        double norm = 0.0;
        for (int i = 0; i < map.getRowCount(); ++i) {
            for (int j = i + 1; j < map.getRowCount(); ++j) {
                double highdim_distance = distanceTable.getDouble(distanceTable.getRowKey(i), distanceTable.getColumnKey(j));
                double delta_x = map.getX(i) - map.getX(j);
                double delta_y = map.getY(i) - map.getY(j);
                double lowdim_distance = Math.sqrt(delta_x * delta_x + delta_y * delta_y);
                double delta_distance = lowdim_distance - highdim_distance;
                squared_distances += delta_distance * delta_distance;
                norm += lowdim_distance * lowdim_distance;
            }
        }
        return squared_distances / norm;
    }
}

