/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.mds.sammon;

import com.macrofocus.high_d.mds.AbstractMDSEngine;
import com.macrofocus.high_d.mds.MDSEngineEvent;
import com.macrofocus.high_d.mds.MDSModel;
import com.macrofocus.high_d.mds.MutableMDSModel;
import com.macrofocus.molap.dataframe.matrix.Matrix;
import com.macrofocus.timer.CPExecutor;
import java.util.Random;

public final class SammonMDSEngine
extends AbstractMDSEngine {
    private Matrix _dist;
    private MutableMDSModel sammonModel;
    private Random _rand;
    private static double MAGIC = 0.2;
    private int length;

    public SammonMDSEngine(CPExecutor executor) {
        super(executor);
    }

    public SammonMDSEngine(MutableMDSModel sammonModel, Matrix dist, int length, CPExecutor executor) {
        this(executor);
        this.setParameters(sammonModel, dist, length);
    }

    @Override
    public MDSModel getModel() {
        return this.sammonModel;
    }

    @Override
    protected Matrix getDistanceTable() {
        return this._dist;
    }

    public void setParameters(MutableMDSModel sammonModel, Matrix dist, int length) {
        this.sammonModel = sammonModel;
        this._dist = dist;
        this._rand = new Random(123L);
        this.setLength(length);
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public CPExecutor.Command createRunCommand() {
        return new CPExecutor.Command(){
            int progress = -1;
            int noc;
            double[] xu;
            double[] yu;
            {
                this.noc = SammonMDSEngine.this.sammonModel.getRowCount();
                this.xu = new double[this.noc];
                this.yu = new double[this.noc];
            }

            public boolean execute() {
                if (this.progress < 0) {
                    for (int iv = 0; iv < SammonMDSEngine.this.sammonModel.getRowCount(); ++iv) {
                        double x = (double)(SammonMDSEngine.this._rand.nextInt() % SammonMDSEngine.this.sammonModel.getRowCount()) / (double)SammonMDSEngine.this.sammonModel.getRowCount();
                        double y = (double)iv / (double)SammonMDSEngine.this.sammonModel.getRowCount();
                        SammonMDSEngine.this.sammonModel.setX(iv, x);
                        SammonMDSEngine.this.sammonModel.setY(iv, y);
                    }
                }
                ++this.progress;
                if (this.progress < SammonMDSEngine.this.length && !SammonMDSEngine.this.isInterrupted()) {
                    double y;
                    double x;
                    int jv;
                    int rowCount = SammonMDSEngine.this.sammonModel.getRowCount();
                    for (int jv2 = 0; jv2 < rowCount; ++jv2) {
                        double e1y = 0.0;
                        double e2x = 0.0;
                        double e2y = 0.0;
                        double e1x = 0.0;
                        for (int kv = 0; kv < rowCount; ++kv) {
                            if (jv2 == kv || !SammonMDSEngine.this._dist.isAvailable((Object)kv, (Object)jv2)) continue;
                            double dt = SammonMDSEngine.this._dist.getDouble((Object)kv, (Object)jv2);
                            if (!Double.isNaN(dt)) {
                                if (dt > 0.0) {
                                    double yd;
                                    double xd = SammonMDSEngine.this.sammonModel.getX(jv2) - SammonMDSEngine.this.sammonModel.getX(kv);
                                    double dpj = Math.sqrt(xd * xd + (yd = SammonMDSEngine.this.sammonModel.getY(jv2) - SammonMDSEngine.this.sammonModel.getY(kv)) * yd);
                                    if (dpj == 0.0) {
                                        dpj = 1.0E-10;
                                    }
                                    double dq = dt - dpj;
                                    double dr = dt * dpj;
                                    e1x += xd * dq / dr;
                                    e1y += yd * dq / dr;
                                    e2x += (dq - xd * xd * (1.0 + dq / dpj) / dpj) / dr;
                                    e2y += (dq - yd * yd * (1.0 + dq / dpj) / dpj) / dr;
                                    continue;
                                }
                                System.err.println("Identical entry " + kv + ", " + jv2 + ": " + dt);
                                continue;
                            }
                            System.err.println("Unknown distance comparing " + jv2 + " and " + kv);
                        }
                        this.xu[jv2] = e2x != 0.0 ? SammonMDSEngine.this.sammonModel.getX(jv2) + MAGIC * e1x / Math.abs(e2x) : SammonMDSEngine.this.sammonModel.getX(jv2);
                        this.yu[jv2] = e2y != 0.0 ? SammonMDSEngine.this.sammonModel.getY(jv2) + MAGIC * e1y / Math.abs(e2y) : SammonMDSEngine.this.sammonModel.getY(jv2);
                    }
                    int n = 0;
                    double xx = 0.0;
                    double yy = 0.0;
                    for (jv = 0; jv < rowCount; ++jv) {
                        x = this.xu[jv];
                        y = this.yu[jv];
                        if (Double.isNaN(x) || Double.isNaN(y) || Double.isInfinite(x) || Double.isInfinite(y)) continue;
                        xx += x;
                        yy += y;
                        ++n;
                    }
                    xx /= (double)n;
                    yy /= (double)n;
                    for (jv = 0; jv < rowCount; ++jv) {
                        x = this.xu[jv] - xx;
                        y = this.yu[jv] - yy;
                        if (Double.isNaN(x) || Double.isNaN(y) || Double.isInfinite(x) || Double.isInfinite(y)) continue;
                        SammonMDSEngine.this.sammonModel.setX(jv, x);
                        SammonMDSEngine.this.sammonModel.setY(jv, y);
                    }
                    SammonMDSEngine.this.notifyEngineIterated(new MDSEngineEvent(SammonMDSEngine.this, this.progress));
                    ++this.progress;
                    return true;
                }
                SammonMDSEngine.this.notifyEngineFinished(new MDSEngineEvent(SammonMDSEngine.this, SammonMDSEngine.this.length));
                return false;
            }
        };
    }
}

