/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.mds.sammon;

import com.macrofocus.high_d.mds.AbstractMDSModel;
import com.macrofocus.high_d.mds.sammon.SammonModel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.matrix.SimpleMutableMatrix;
import com.macrofocus.molap.index.DefaultUniqueIndex;
import com.macrofocus.molap.index.IntegerRangeUniqueIndex;
import com.macrofocus.molap.index.UniqueIndex;
import java.util.Random;

public class SimpleSammonModel
extends AbstractMDSModel
implements SammonModel {
    private final Random _rand = new Random(123L);
    private final SimpleMutableMatrix matrix;
    private final UniqueIndex<Integer> rowIndex;
    private final UniqueIndex<String> columnIndex;

    public SimpleSammonModel(DataFrame dataset) {
        this.matrix = new SimpleMutableMatrix(dataset.getRowCount(), 2);
        this.rowIndex = new IntegerRangeUniqueIndex(0, dataset.getRowCount() - 1);
        this.columnIndex = new DefaultUniqueIndex((Object[])new String[]{"X", "Y"});
        for (int iv = 0; iv < this.getRowCount(); ++iv) {
            double x = (double)(this._rand.nextInt() % this.getRowCount()) / (double)this.getRowCount();
            double y = (double)iv / (double)this.getRowCount();
            this.setX(iv, x);
            this.setY(iv, y);
        }
    }

    public Object getValueAt(int row, int column) {
        return this.matrix.getValueAt((Object)row, (Object)column);
    }

    public boolean isAvailable(int row, int column) {
        return this.matrix.isAvailable((Object)row, (Object)column);
    }

    public double getDouble(Integer row, Integer column) {
        return this.matrix.getDouble(row, column);
    }

    public void setDouble(int row, int column, double value) {
        this.matrix.setDouble(Integer.valueOf(row), Integer.valueOf(column), value);
    }

    @Override
    public int getRowCount() {
        return this.matrix.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.matrix.getColumnCount();
    }

    @Override
    public void setX(int row, double x) {
        this.setDouble(row, 0, x);
    }

    @Override
    public void setY(int row, double y) {
        this.setDouble(row, 1, y);
    }

    @Override
    public double getX(int row) {
        return this.getDouble((Integer)row, 0);
    }

    @Override
    public double getY(int row) {
        return this.getDouble((Integer)row, 1);
    }

    @Override
    public Object getColumnName(int column) {
        return this.matrix.getColumnName((Object)column);
    }

    public int getColumnIndex(Object name) {
        int index = -1;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.getColumnName(i).equals(name)) continue;
            index = i;
        }
        return index;
    }

    public Class getColumnClass(int column) {
        return this.matrix.getColumnClass((Object)column);
    }

    public UniqueIndex<Integer> getRowIndex() {
        return this.rowIndex;
    }

    public UniqueIndex<String> getColumnIndex() {
        return this.columnIndex;
    }
}

