/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.parallelcoordinates.blending;

import com.macrofocus.high_d.parallelcoordinates.blending.BlendingMode;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.WritableRaster;

public final class BlendingComposite
implements Composite {
    private final float alpha;
    private final BlendingMode mode;

    private BlendingComposite(BlendingMode mode) {
        this(mode, 1.0f);
    }

    private BlendingComposite(BlendingMode mode, float alpha) {
        this.mode = mode;
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new IllegalArgumentException("alpha must be comprised between 0.0f and 1.0f");
        }
        this.alpha = alpha;
    }

    public static BlendingComposite getInstance(BlendingMode mode) {
        return new BlendingComposite(mode);
    }

    public static BlendingComposite getInstance(BlendingMode mode, float alpha) {
        return new BlendingComposite(mode, alpha);
    }

    float getAlpha() {
        return this.alpha;
    }

    BlendingMode getMode() {
        return this.mode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlendingComposite)) {
            return false;
        }
        BlendingComposite bc = (BlendingComposite)obj;
        return this.mode == bc.mode && this.alpha == bc.alpha;
    }

    private static boolean isRgbColorModel(ColorModel cm) {
        if (cm instanceof DirectColorModel && cm.getTransferType() == 3) {
            DirectColorModel directCM = (DirectColorModel)cm;
            return directCM.getRedMask() == 0xFF0000 && directCM.getGreenMask() == 65280 && directCM.getBlueMask() == 255 && (directCM.getNumComponents() == 3 || directCM.getAlphaMask() == -16777216);
        }
        return false;
    }

    private static boolean isBgrColorModel(ColorModel cm) {
        if (cm instanceof DirectColorModel && cm.getTransferType() == 3) {
            DirectColorModel directCM = (DirectColorModel)cm;
            return directCM.getRedMask() == 255 && directCM.getGreenMask() == 65280 && directCM.getBlueMask() == 0xFF0000 && (directCM.getNumComponents() == 3 || directCM.getAlphaMask() == -16777216);
        }
        return false;
    }

    @Override
    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        if (BlendingComposite.isRgbColorModel(srcColorModel) && BlendingComposite.isRgbColorModel(dstColorModel)) {
            return new BlendingRgbContext(this);
        }
        if (BlendingComposite.isBgrColorModel(srcColorModel) && BlendingComposite.isBgrColorModel(dstColorModel)) {
            return new BlendingBgrContext(this);
        }
        throw new RasterFormatException("Incompatible color models:\n  " + String.valueOf(srcColorModel) + "\n  " + String.valueOf(dstColorModel));
    }

    private static class BlendingRgbContext
    extends BlendingContext {
        private BlendingRgbContext(BlendingComposite composite) {
            super(composite);
        }

        @Override
        public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
            int width = Math.min(src.getWidth(), dstIn.getWidth());
            int height = Math.min(src.getHeight(), dstIn.getHeight());
            float alpha = this.composite.getAlpha();
            int[] result = new int[4];
            int[] srcPixel = new int[4];
            int[] dstPixel = new int[4];
            int[] srcPixels = new int[width];
            int[] dstPixels = new int[width];
            for (int y = 0; y < height; ++y) {
                src.getDataElements(0, y, width, 1, srcPixels);
                dstIn.getDataElements(0, y, width, 1, dstPixels);
                for (int x = 0; x < width; ++x) {
                    int pixel = srcPixels[x];
                    srcPixel[0] = pixel >> 16 & 0xFF;
                    srcPixel[1] = pixel >> 8 & 0xFF;
                    srcPixel[2] = pixel & 0xFF;
                    srcPixel[3] = pixel >> 24 & 0xFF;
                    pixel = dstPixels[x];
                    dstPixel[0] = pixel >> 16 & 0xFF;
                    dstPixel[1] = pixel >> 8 & 0xFF;
                    dstPixel[2] = pixel & 0xFF;
                    dstPixel[3] = pixel >> 24 & 0xFF;
                    this.composite.getMode().blend(srcPixel, dstPixel, result);
                    dstPixels[x] = ((int)((float)dstPixel[3] + (float)(result[3] - dstPixel[3]) * alpha) & 0xFF) << 24 | ((int)((float)dstPixel[0] + (float)(result[0] - dstPixel[0]) * alpha) & 0xFF) << 16 | ((int)((float)dstPixel[1] + (float)(result[1] - dstPixel[1]) * alpha) & 0xFF) << 8 | (int)((float)dstPixel[2] + (float)(result[2] - dstPixel[2]) * alpha) & 0xFF;
                }
                dstOut.setDataElements(0, y, width, 1, dstPixels);
            }
        }
    }

    private static class BlendingBgrContext
    extends BlendingContext {
        private BlendingBgrContext(BlendingComposite composite) {
            super(composite);
        }

        @Override
        public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
            int width = Math.min(src.getWidth(), dstIn.getWidth());
            int height = Math.min(src.getHeight(), dstIn.getHeight());
            float alpha = this.composite.getAlpha();
            int[] result = new int[4];
            int[] srcPixel = new int[4];
            int[] dstPixel = new int[4];
            int[] srcPixels = new int[width];
            int[] dstPixels = new int[width];
            for (int y = 0; y < height; ++y) {
                src.getDataElements(0, y, width, 1, srcPixels);
                dstIn.getDataElements(0, y, width, 1, dstPixels);
                for (int x = 0; x < width; ++x) {
                    int pixel = srcPixels[x];
                    srcPixel[0] = pixel & 0xFF;
                    srcPixel[1] = pixel >> 8 & 0xFF;
                    srcPixel[2] = pixel >> 16 & 0xFF;
                    srcPixel[3] = pixel >> 24 & 0xFF;
                    pixel = dstPixels[x];
                    dstPixel[0] = pixel & 0xFF;
                    dstPixel[1] = pixel >> 8 & 0xFF;
                    dstPixel[2] = pixel >> 16 & 0xFF;
                    dstPixel[3] = pixel >> 24 & 0xFF;
                    this.composite.getMode().blend(srcPixel, dstPixel, result);
                    dstPixels[x] = ((int)((float)dstPixel[3] + (float)(result[3] - dstPixel[3]) * alpha) & 0xFF) << 24 | (int)((float)dstPixel[0] + (float)(result[0] - dstPixel[0]) * alpha) & 0xFF | ((int)((float)dstPixel[1] + (float)(result[1] - dstPixel[1]) * alpha) & 0xFF) << 8 | ((int)((float)dstPixel[2] + (float)(result[2] - dstPixel[2]) * alpha) & 0xFF) << 16;
                }
                dstOut.setDataElements(0, y, width, 1, dstPixels);
            }
        }
    }

    private static abstract class BlendingContext
    implements CompositeContext {
        final BlendingComposite composite;

        private BlendingContext(BlendingComposite composite) {
            this.composite = composite;
        }

        @Override
        public void dispose() {
        }
    }
}

