/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.parallelcoordinates.geometry;

import com.macrofocus.geom.GeneralPath;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.geom.curve.CatmullRomSpline;
import com.macrofocus.geom.curve.ControlPath;
import com.macrofocus.geom.curve.Curve;
import com.macrofocus.geom.curve.GroupIterator;
import com.macrofocus.geom.curve.MultiPath;
import com.macrofocus.geom.curve.Point;
import com.macrofocus.geom.curve.ShapeMultiPath;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesModel;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesView;
import com.macrofocus.high_d.parallelcoordinates.layout.ParallelCoordinatesLayout;

public enum Geometry {
    Polylines{

        @Override
        public <Color, R> Shape createGeometry(ParallelCoordinatesView view, ParallelCoordinatesModel<Color, R, ?> model, int fullHeight, int layer, R row, int level) {
            GeneralPath path = null;
            boolean previousAvailable = false;
            ParallelCoordinatesLayout layout = view.getParallelCoordinatesLayout();
            for (AxisGroupModel axisGroup : layout.getAxisGroups(level)) {
                for (AxisModel axisModel : axisGroup.getAxisOrder()) {
                    boolean currentAvailable;
                    Rectangle2D trackBounds = layout.getTrackBounds(axisGroup, axisModel);
                    int x = (int)trackBounds.getX() + layout.getAxisPreferredWidth() / 2;
                    Number value = axisModel.getValue(layer, row);
                    boolean bl = currentAvailable = value != null;
                    if (currentAvailable) {
                        int height = (int)trackBounds.getHeight();
                        double y = 1.getY(fullHeight, height, layout.getAxisAfterTrackGap(), value.doubleValue(), axisModel);
                        if (path != null) {
                            if (previousAvailable) {
                                path.lineTo((double)x, y);
                            } else {
                                path.moveTo((double)(x - 1), y);
                                path.lineTo((double)x, y);
                            }
                        } else {
                            path = new GeneralPath();
                            path.moveTo((double)x, y);
                        }
                    }
                    previousAvailable = currentAvailable;
                }
            }
            return path;
        }
    }
    ,
    Steps{

        @Override
        public <Color, R> Shape createGeometry(ParallelCoordinatesView view, ParallelCoordinatesModel<Color, R, ?> model, int fullHeight, int layer, R row, int level) {
            GeneralPath path = null;
            boolean previousAvailable = false;
            ParallelCoordinatesLayout layout = view.getParallelCoordinatesLayout();
            for (AxisGroupModel axisGroup : layout.getAxisGroups(level)) {
                for (AxisModel axisModel : axisGroup.getAxisOrder()) {
                    boolean currentAvailable;
                    Rectangle2D trackBounds = layout.getTrackBounds(axisGroup, axisModel);
                    int x = view.getAxisX(axisGroup, axisModel);
                    Number value = axisModel.getValue(layer, row);
                    boolean bl = currentAvailable = value != null;
                    if (currentAvailable) {
                        int height = (int)trackBounds.getHeight();
                        double y = 2.getY(fullHeight, height, layout.getAxisAfterTrackGap(), value.doubleValue(), axisModel);
                        if (path != null) {
                            if (previousAvailable) {
                                path.lineTo((double)x, y);
                            } else {
                                path.moveTo((double)x, y);
                            }
                            path.lineTo((double)(x + layout.getAxisPreferredWidth()), y);
                        } else {
                            path = new GeneralPath();
                            path.moveTo((double)x, y);
                            path.lineTo((double)(x + layout.getAxisPreferredWidth()), y);
                        }
                    }
                    previousAvailable = currentAvailable;
                }
            }
            return path;
        }
    }
    ,
    Polycurves{

        @Override
        public <Color, R> Shape createGeometry(ParallelCoordinatesView view, ParallelCoordinatesModel<Color, R, ?> model, int fullHeight, int layer, R row, int level) {
            double x = 0.0;
            double y = 0.0;
            ControlPath curves = new ControlPath();
            ControlPath cp = null;
            boolean previousAvailable = false;
            ParallelCoordinatesLayout layout = view.getParallelCoordinatesLayout();
            for (AxisGroupModel axisGroup : layout.getAxisGroups(level)) {
                for (AxisModel axisModel : axisGroup.getAxisOrder()) {
                    boolean currentAvailable;
                    Rectangle2D trackBounds = layout.getTrackBounds(axisGroup, axisModel);
                    x = view.getAxisX(axisGroup, axisModel) + layout.getAxisPreferredWidth() / 2;
                    Number value = axisModel.getValue(layer, row);
                    boolean bl = currentAvailable = value != null;
                    if (currentAvailable) {
                        int height = (int)trackBounds.getHeight();
                        y = 3.getY(fullHeight, height, layout.getAxisAfterTrackGap(), value.doubleValue(), axisModel);
                        assert (!Double.isNaN(y) && !Double.isInfinite(y));
                        if (cp != null) {
                            if (previousAvailable) {
                                cp.addPoint(Geometry.createPoint2(x, y));
                            } else {
                                System.err.println("Error");
                            }
                        } else {
                            cp = new ControlPath();
                            cp.addPoint(Geometry.createPoint2(x, y));
                            cp.addPoint(Geometry.createPoint2(x, y));
                        }
                        previousAvailable = currentAvailable;
                        continue;
                    }
                    if (cp != null) {
                        cp.addPoint(Geometry.createPoint2(x, y));
                        CatmullRomSpline cardinalSpline = new CatmullRomSpline(cp, new GroupIterator(new int[]{0, cp.numPoints() - 1}));
                        curves.addCurve((Curve)cardinalSpline);
                    }
                    cp = null;
                }
            }
            if (cp != null) {
                cp.addPoint(Geometry.createPoint2(x, y));
                CatmullRomSpline cardinalSpline = new CatmullRomSpline(cp, new GroupIterator(new int[]{0, cp.numPoints() - 1}));
                curves.addCurve((Curve)cardinalSpline);
            }
            int dimension = 2;
            ShapeMultiPath mp = new ShapeMultiPath(2);
            mp.setFlatness(1.0);
            for (int i = 0; i < curves.numCurves(); ++i) {
                Curve curve = curves.getCurve(i);
                curve.appendTo((MultiPath)mp);
            }
            return mp;
        }
    };


    public abstract <Color, R> Shape createGeometry(ParallelCoordinatesView var1, ParallelCoordinatesModel<Color, R, ?> var2, int var3, int var4, R var5, int var6);

    public static double getY(int fullHeight, int height, int offset, double value, AxisModel axisModel) {
        if (!axisModel.isDegenerate()) {
            return (double)(fullHeight - 1) - (double)(height - 1) * axisModel.getNormalized(value) - (double)offset;
        }
        return (double)fullHeight - (double)height * 0.5 - (double)offset;
    }

    private static Point createPoint(double x, double y) {
        final double[] arr = new double[]{x, y};
        return new Point(){

            public double[] getLocation() {
                return arr;
            }
        };
    }

    private static Point createPoint2(double x, double y) {
        final double[] arr = new double[]{x, y};
        return new Point(){

            public double[] getLocation() {
                return arr;
            }
        };
    }
}

