/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.scatterplotmatrix;

import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.high_d.scatterplotmatrix.ScatterPlotMatrix;
import com.macrofocus.high_d.scatterplotmatrix.ScatterPlotMatrixController;
import com.macrofocus.high_d.scatterplotmatrix.ScatterPlotMatrixModel;
import com.macrofocus.high_d.scatterplotmatrix.ScatterPlotMatrixView;
import com.macrofocus.license.LicenseModel;
import com.macrofocus.license.SimpleLicenseModel;
import com.macrofocus.molap.dataframe.DataFrame;

public abstract class AbstractScatterPlotMatrix<Component, Color, R, C>
implements ScatterPlotMatrix<Component, Color, R, C> {
    protected static LicenseModel licenseModel;
    private ScatterPlotMatrixModel model;
    protected ScatterPlotMatrixView<Component, Color, R, C> view;
    protected ScatterPlotMatrixController controller;

    public static void setLicenseKey(String username, String key) {
        licenseModel = new SimpleLicenseModel(ApplicationModelFactory.HIGHD_API, username, key);
    }

    protected void load(DataFrame dataFrame) {
        this.setModel(this.createScatterPlotMatrixModel(dataFrame));
    }

    @Override
    public ScatterPlotMatrixModel getModel() {
        return this.model;
    }

    @Override
    public void setModel(ScatterPlotMatrixModel model) {
        if (this.model != model) {
            this.model = model;
            if (this.view != null) {
                this.view.setModel(model);
            }
        }
    }

    @Override
    public ScatterPlotMatrixView<Component, Color, R, C> getView() {
        return this.view;
    }

    @Override
    public void setView(ScatterPlotMatrixView<Component, Color, R, C> view) {
        if (this.view != view) {
            if (this.view != null) {
                this.view.setModel(null);
            }
            this.view = view;
            if (view != null) {
                view.setModel(this.model);
                this.view.setLicenseModel(licenseModel);
            }
        }
    }

    @Override
    public ScatterPlotMatrixController getController() {
        return this.controller;
    }

    @Override
    public void setController(ScatterPlotMatrixController controller) {
        if (this.controller != controller) {
            if (this.controller != null) {
                this.controller.setView(null);
            }
            this.controller = controller;
            if (controller != null) {
                controller.setView(this.view);
            }
        }
    }

    protected abstract ScatterPlotMatrixModel createScatterPlotMatrixModel(DataFrame var1);

    protected abstract ScatterPlotMatrixView createView();

    protected abstract ScatterPlotMatrixController createController(ScatterPlotMatrixView var1);
}

