/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.som;

import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.high_d.som.SOM;
import com.macrofocus.high_d.som.SOMController;
import com.macrofocus.high_d.som.SOMModel;
import com.macrofocus.high_d.som.SOMView;
import com.macrofocus.license.LicenseModel;
import com.macrofocus.license.SimpleLicenseModel;
import com.macrofocus.molap.dataframe.DataFrame;

public abstract class AbstractSOM<Component, Color, Row, Column>
implements SOM<Component, Color, Row, Column> {
    private SOMModel<Color, Row, Column> model;
    protected SOMView<Component, Color, Row, Column> view;
    protected SOMController controller;
    protected static LicenseModel licenseModel;

    public AbstractSOM(SOMModel<Color, Row, Column> model) {
        this.model = model;
    }

    public static void setLicenseKey(String username, String key) {
        licenseModel = new SimpleLicenseModel(ApplicationModelFactory.HIGHD_API_V1, username, key);
    }

    protected void load(DataFrame dataFrame) {
        this.setModel(this.createModel(dataFrame));
    }

    @Override
    public SOMModel<Color, Row, Column> getModel() {
        return this.model;
    }

    @Override
    public void setModel(SOMModel<Color, Row, Column> model) {
        if (this.model != model) {
            this.model = model;
            if (this.view != null) {
                this.view.setModel(model);
            }
        }
    }

    @Override
    public SOMView<Component, Color, Row, Column> getView() {
        return this.view;
    }

    @Override
    public void setView(SOMView<Component, Color, Row, Column> view) {
        if (this.view != view) {
            if (this.view != null) {
                this.view.setModel(null);
            }
            this.view = view;
            if (view != null) {
                view.setModel(this.model);
                this.view.setLicenseModel(licenseModel);
            }
        }
    }

    @Override
    public SOMController getController() {
        return this.controller;
    }

    @Override
    public void setController(SOMController controller) {
        if (this.controller != controller) {
            if (this.controller != null) {
                this.controller.setView(null);
            }
            this.controller = controller;
            if (controller != null) {
                controller.setView(this.view);
            }
        }
    }

    protected abstract SOMModel<Color, Row, Column> createModel(DataFrame var1);

    protected abstract SOMView<Component, Color, Row, Column> createView();

    protected abstract SOMController createController(SOMView var1);
}

