/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.statistics;

import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.statistics.StatisticsDataFrame;
import com.macrofocus.molap.dataframe.AbstractDataFrame;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.DataFrameEvent;
import com.macrofocus.molap.dataframe.DataFrameListener;
import com.macrofocus.molap.index.DefaultUniqueIndex;
import com.macrofocus.molap.index.UniqueIndex;
import com.macrofocus.molap.series.Series;
import com.macrofocus.order.OrderEvent;
import com.macrofocus.order.OrderListener;
import com.macrofocus.timer.CPTimer;
import com.macrofocus.timer.CPTimerListener;
import java.util.ArrayList;

public class PresentationStatisticsDataFrame<Row, C>
extends AbstractDataFrame<StatisticsDataFrame.Stat, C, Object> {
    private final StatisticsDataFrame<Row, C> dataFrame;
    private final AxisGroupModel<Row, C> axisGroupModel;
    private UniqueIndex<C> columnIndex = null;
    private final CPTimer structureChangedTimer;
    private final CPTimer dataChangedTimer;
    final DataFrameListener dataFrameListener = new DataFrameListener(){

        public void dataFrameChanged(DataFrameEvent event) {
            PresentationStatisticsDataFrame.this.scheduleTableDataChanged();
        }
    };

    public PresentationStatisticsDataFrame(CPFactory factory, StatisticsDataFrame dataFrame, AxisGroupModel<Row, C> axisGroupModel) {
        this.dataFrame = dataFrame;
        this.axisGroupModel = axisGroupModel;
        this.structureChangedTimer = factory.createTimer("StatisticsPresentation$Structure", 50, true, new CPTimerListener(){

            public void timerTriggered() {
                PresentationStatisticsDataFrame.this.columnIndex = null;
                PresentationStatisticsDataFrame.this.notifyDataFrameChanged(new DataFrameEvent(null, null, true));
            }
        });
        this.dataChangedTimer = factory.createTimer("StatisticsPresentation$Data", 50, true, new CPTimerListener(){

            public void timerTriggered() {
                PresentationStatisticsDataFrame.this.notifyDataFrameChanged(new DataFrameEvent(null, null, false));
            }
        });
        dataFrame.addWeakDataFrameListener(this.dataFrameListener);
        axisGroupModel.getAxisOrder().addOrderListener(new OrderListener<AxisModel<Row, C>>(){

            public void orderChanged(OrderEvent<AxisModel<Row, C>> event) {
                PresentationStatisticsDataFrame.this.scheduleTableStructureChanged();
            }

            public void orderVisibility(OrderEvent<AxisModel<Row, C>> event) {
                PresentationStatisticsDataFrame.this.scheduleTableStructureChanged();
            }

            public void orderAdded(OrderEvent<AxisModel<Row, C>> event) {
                PresentationStatisticsDataFrame.this.scheduleTableStructureChanged();
            }

            public void orderRemoved(OrderEvent<AxisModel<Row, C>> event) {
                PresentationStatisticsDataFrame.this.scheduleTableStructureChanged();
            }
        });
    }

    private void scheduleTableStructureChanged() {
        this.structureChangedTimer.restart();
    }

    private void scheduleTableDataChanged() {
        this.dataChangedTimer.restart();
    }

    public String getColumnName(C column) {
        return this.dataFrame.getColumnName(column);
    }

    public Class<?> getColumnClass(C columnIndex) {
        if (columnIndex != null) {
            return this.dataFrame.getColumnClass(columnIndex);
        }
        return String.class;
    }

    public int getRowCount() {
        return this.dataFrame.getRowCount();
    }

    public int getColumnCount() {
        return this.axisGroupModel.getAxisOrder().size() + 1;
    }

    public Object getValueAt(StatisticsDataFrame.Stat rowIndex, C columnIndex) {
        switch (this.getColumnAddress(columnIndex)) {
            case 0: {
                return rowIndex.toString();
            }
        }
        return this.dataFrame.getValueAt(rowIndex, columnIndex);
    }

    public Class getRowClass(StatisticsDataFrame.Stat integer) {
        return Object.class;
    }

    public Series<C, ?> getRow(StatisticsDataFrame.Stat integer) {
        return null;
    }

    public UniqueIndex<StatisticsDataFrame.Stat> getRowIndex() {
        return this.dataFrame.getRowIndex();
    }

    public UniqueIndex<C> getColumnIndex() {
        if (this.columnIndex == null) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(null);
            for (AxisModel axisModel : this.axisGroupModel.getAxisOrder()) {
                list.add(axisModel.getColumn());
            }
            this.columnIndex = new DefaultUniqueIndex(list.toArray());
        }
        return this.columnIndex;
    }

    public DataFrame join(Series series, Object[] cs) {
        return null;
    }
}

