/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.tablelens;

import com.macrofocus.common.properties.Property;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.high_d.axis.AxisListener;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.tablelens.TableLensComponent;
import com.macrofocus.high_d.tablelens.TableLensListener;
import com.macrofocus.high_d.tablelens.TableLensModel;
import com.macrofocus.high_d.tablelens.TableLensView;
import com.macrofocus.igraphics.AbstractIDrawing;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.IDrawing;
import com.macrofocus.igraphics.IGraphics;
import com.macrofocus.igraphics.colortheme.ColorTheme;
import com.macrofocus.igraphics.pressure.LogPressure;
import com.macrofocus.igraphics.pressure.Pressure;
import com.macrofocus.order.MutableVisibleOrder;
import com.macrofocus.order.OrderEvent;
import com.macrofocus.order.OrderListener;
import com.macrofocus.palette.FixedPalette;
import com.macrofocus.rubberband.RubberbandDrawing;
import com.macrofocus.timer.CPTimer;
import com.macrofocus.timer.CPTimerListener;
import com.macrofocus.timer.VisualizationExecutorService;
import com.macrofocus.visual.VisualLayer;
import com.macrofocus.visual.VisualListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class AbstractTableLensComponent<Component, Color, Row, C>
implements TableLensComponent<Component, Row, C> {
    protected TableLensModel<Color, Row, C> model;
    private final double margin = 0.2;
    protected final CPCanvas canvas;
    private final CPFactory<?, ?, ?, Color> factory;
    private static final boolean MULTITHREADED = true;
    private static final VisualizationExecutorService executor = VisualizationExecutorService.getInstance();
    protected final TableLensView<Component, Color, Row, C> view;
    private final TableLensListener listener = new TableLensListener(){

        @Override
        public void tableLensChanged() {
            AbstractTableLensComponent.this.timer.restart();
        }
    };
    private final AxisListener axisListener = new AxisListener(){

        public void axisChanged() {
            AbstractTableLensComponent.this.scheduleUpdate();
        }
    };
    private final OrderListener<AxisModel<Row, C>> orderListener = new OrderListener<AxisModel<Row, C>>(){

        public void orderChanged(OrderEvent<AxisModel<Row, C>> event) {
            AbstractTableLensComponent.this.scheduleUpdate();
        }

        public void orderVisibility(OrderEvent<AxisModel<Row, C>> event) {
            AbstractTableLensComponent.this.scheduleUpdate();
        }

        public void orderAdded(OrderEvent<AxisModel<Row, C>> event) {
            AbstractTableLensComponent.this.scheduleUpdate();
        }

        public void orderRemoved(OrderEvent<AxisModel<Row, C>> event) {
            AbstractTableLensComponent.this.scheduleUpdate();
        }
    };
    protected final CPTimer timer;

    protected AbstractTableLensComponent(TableLensView view, CPCanvas canvas, CPFactory<?, ?, ?, Color> factory) {
        this.view = view;
        this.canvas = canvas;
        this.factory = factory;
        this.timer = factory.createTimer("TableLensResizer", 50, false, new CPTimerListener(){

            public void timerTriggered() {
                if (AbstractTableLensComponent.this.getWidth() > 0 && AbstractTableLensComponent.this.getHeight() > 0) {
                    AbstractTableLensComponent.this.refresh();
                }
            }
        });
    }

    protected abstract int getWidth();

    protected abstract int getHeight();

    protected abstract void refresh();

    protected abstract void repaint();

    @Override
    public void setModel(TableLensModel model) {
        if (this.model != null) {
            this.model.removeTableLensListener(this.listener);
            this.model.getAxisGroupModel().getAxisOrder().removeOrderListener(this.orderListener);
            this.model.getAxisGroupModel().removeAxisListener(this.axisListener);
        }
        this.model = model;
        if (this.model != null) {
            this.createOverplots();
            this.model.addTableLensListener(this.listener);
            this.model.getAxisGroupModel().getAxisOrder().addOrderListener(this.orderListener);
            this.model.getAxisGroupModel().addAxisListener(this.axisListener);
        }
        this.timer.restart();
    }

    @Override
    public void createOverplots() {
        if (this.model != null) {
            this.canvas.removeAllLayers();
            this.canvas.addLayer((IDrawing)new AbstractIDrawing(){

                public void draw(IGraphics g, Point2D point, double width, double height, Rectangle clipBounds) {
                    CPColor background = ((ColorTheme)AbstractTableLensComponent.this.view.getColorTheme().getValue()).getBackground();
                    if (background != null) {
                        g.setColor(background);
                        g.fillRectangle2D((Rectangle2D)new Rectangle2D.Double(0.0, 0.0, width, height));
                    }
                }
            });
            this.canvas.addDensityLayer((CPCanvas.Rendering)this.view.getRendering().getValue(), (IDrawing)new AbstractVisualLayerIDrawing(this.model.getVisual().getMultipleSelected()){

                @Override
                public void draw(IGraphics g, int x, int y, int width, int height, Row row) {
                    g.fillRectangle(x, y, AbstractTableLensComponent.this.getWidth(), height);
                }
            }, (Pressure)new LogPressure(), new CPCanvas.PaletteProvider(){

                public FixedPalette getPalette() {
                    return ((ColorTheme)AbstractTableLensComponent.this.view.getColorTheme().getValue()).getSelectedShadowPalette();
                }
            });
            this.canvas.addLayer((IDrawing)new AbstractVisualLayerIDrawing(this.model.getVisual().getSingleSelected()){
                final CPColor<Color> color;
                {
                    this.color = AbstractTableLensComponent.this.factory.createRGBColor(255, 0, 0);
                }

                @Override
                public void draw(IGraphics g, int x, int y, int width, int height, Row row) {
                    g.setColor(this.color);
                    g.fillRectangle(x, y, AbstractTableLensComponent.this.getWidth(), height);
                }
            });
            this.canvas.addLayer((IDrawing)new AbstractVisualLayerIDrawing(this.model.getVisual().getProbed()){
                final CPColor<Color> selectionColor;
                final CPColor<Color> color;
                {
                    this.selectionColor = AbstractTableLensComponent.this.factory.createRGBColor(255, 0, 0);
                    this.color = AbstractTableLensComponent.this.factory.createRGBColor(255, 200, 0);
                }

                @Override
                public void draw(IGraphics g, int x, int y, int width, int height, Row row) {
                    g.setColor(this.color);
                    g.fillRectangle(x, y - 1, AbstractTableLensComponent.this.getWidth(), height + 2);
                    if (AbstractTableLensComponent.this.model.getVisual().getSelection().isSelected(row)) {
                        g.setColor(this.selectionColor);
                        g.fillRectangle(x, y, AbstractTableLensComponent.this.getWidth(), height);
                    }
                }
            });
            this.canvas.addDensityLayer((CPCanvas.Rendering)this.view.getRendering().getValue(), (IDrawing)new AbstractVisualLayerIDrawing(this.model.getVisual().getFiltered()){

                @Override
                public boolean isActive() {
                    return (Boolean)AbstractTableLensComponent.this.view.getShowFiltered().getValue() != false && super.isActive();
                }

                @Override
                public void draw(IGraphics g, int x, int y, int width, int height, Row row) {
                    g.fillRectangle(x, y, width, height);
                }
            }, (Pressure)new LogPressure(), new CPCanvas.PaletteProvider(){

                public FixedPalette getPalette() {
                    return ((ColorTheme)AbstractTableLensComponent.this.view.getColorTheme().getValue()).getGhostedPalette();
                }
            });
            this.canvas.addDensityLayer((CPCanvas.Rendering)this.view.getRendering().getValue(), (IDrawing)new AbstractVisualLayerIDrawing(this.model.getVisual().getVisible()){

                @Override
                public void draw(IGraphics g, int x, int y, int width, int height, Row row) {
                    g.fillRectangle(x, y, width, height);
                }
            }, (Pressure)new LogPressure(), new CPCanvas.PaletteProvider(){

                public FixedPalette getPalette() {
                    return ((ColorTheme)AbstractTableLensComponent.this.view.getColorTheme().getValue()).getVisiblePalette();
                }
            });
            this.canvas.addAveragingLayer((CPCanvas.Rendering)this.view.getRendering().getValue(), (IDrawing)new AbstractVisualLayerIDrawing(this.model.getVisual().getColorMapped()){

                @Override
                public void draw(IGraphics g, int x, int y, int width, int height, Row row) {
                    g.setColor(AbstractTableLensComponent.this.model.getColorMapping().getColor(row));
                    g.fillRectangle(x, y, width, height);
                }
            });
            this.canvas.addBufferedLayer((IDrawing)new AbstractVisualLayerIDrawing(this.model.getVisual().getColored()){

                @Override
                public void draw(IGraphics g, int x, int y, int width, int height, Row row) {
                    g.setColor(AbstractTableLensComponent.this.model.getColoring().getColor(row));
                    g.fillRectangle(x, y, width, height);
                }
            });
            this.canvas.addDensityLayer((CPCanvas.Rendering)this.view.getRendering().getValue(), (IDrawing)new AbstractVisualLayerIDrawing(this.model.getVisual().getMultipleSelected()){

                @Override
                public void draw(IGraphics g, int x, int y, int width, int height, Row row) {
                    g.fillRectangle(x, y, width, height);
                }
            }, (Pressure)new LogPressure(), new CPCanvas.PaletteProvider(){

                public FixedPalette getPalette() {
                    return ((ColorTheme)AbstractTableLensComponent.this.view.getColorTheme().getValue()).getSelectedPalette();
                }
            });
            this.canvas.addLayer((IDrawing)new AbstractVisualLayerIDrawing(this.model.getVisual().getSingleSelected()){

                @Override
                public void draw(IGraphics g, int x, int y, int width, int height, Row row) {
                    g.setColor(((ColorTheme)AbstractTableLensComponent.this.view.getColorTheme().getValue()).getSelection());
                    g.fillRectangle(x, y, width, height);
                }
            });
            this.canvas.addLayer((IDrawing)new AbstractVisualLayerIDrawing(this.model.getVisual().getProbed()){

                @Override
                public void draw(IGraphics g, int x, int y, int width, int height, Row row) {
                    g.setColor(((ColorTheme)AbstractTableLensComponent.this.view.getColorTheme().getValue()).getProbing());
                    g.fillRectangle(x, y - 1, width, height + 2);
                    if (AbstractTableLensComponent.this.model.getVisual().getSelection().isSelected(row)) {
                        g.setColor(((ColorTheme)AbstractTableLensComponent.this.view.getColorTheme().getValue()).getSelection());
                        g.fillRectangle(x, y, width, height);
                    }
                }
            });
            this.canvas.addLayer((IDrawing)new RubberbandDrawing((CPColorFactory)this.factory, this.view.getRubberBand()){

                protected Property<ColorTheme<Color>> getColorTheme() {
                    return AbstractTableLensComponent.this.view.getColorTheme();
                }
            });
        }
    }

    private int getY(Row row, int objectCount, int height) {
        if (objectCount > 1) {
            return this.model.getIndex(row) * (height - 1) / objectCount;
        }
        return 0;
    }

    private int getIndex(int y) {
        int index = y * (this.model.getObjectCount() - 1) / (this.getHeight() - 1);
        return index;
    }

    @Override
    public Row getClosestRow(int x, int y) {
        Row row = this.model.getObject(this.getIndex(y));
        if (!this.model.getFilter().isFiltered(row)) {
            return row;
        }
        return null;
    }

    @Override
    public List<Row> getRows(Rectangle2D rect) {
        ArrayList<Row> list = new ArrayList<Row>();
        int index1 = this.getIndex((int)rect.getMinY());
        int index2 = this.getIndex((int)rect.getMaxY());
        for (int i = index1; i <= index2; ++i) {
            Row row = this.model.getObject(i);
            if (this.model.getFilter().isFiltered(row)) continue;
            list.add(row);
        }
        return list;
    }

    public void addMouseListener(CPCanvas.MouseListener l) {
        this.canvas.addMouseListener(l);
    }

    public void addMouseMotionListener(CPCanvas.MouseMotionListener l) {
        this.canvas.addMouseMotionListener(l);
    }

    public void removeMouseListener(CPCanvas.MouseListener l) {
        throw new UnsupportedOperationException();
    }

    public void removeMouseMotionListener(CPCanvas.MouseMotionListener l) {
        throw new UnsupportedOperationException();
    }

    public abstract class AbstractVisualLayerIDrawing
    extends AbstractIDrawing {
        private final VisualLayer<Row> visualLayer;

        protected AbstractVisualLayerIDrawing(VisualLayer<Row> visualLayer) {
            this.visualLayer = visualLayer;
            visualLayer.addVisualListener(new VisualListener(){

                public void visualChanged() {
                    AbstractVisualLayerIDrawing.this.notifyIDrawingChanged();
                }
            });
        }

        public boolean isActive() {
            return this.visualLayer.isActive();
        }

        public void draw(final IGraphics g, Point2D point, double gw, double gh, Rectangle clipBounds) {
            block11: {
                if (this.visualLayer.getObjectCount() <= 0) break block11;
                final int height = AbstractTableLensComponent.this.getHeight();
                final MutableVisibleOrder axisOrder = AbstractTableLensComponent.this.model.getAxisGroupModel().getAxisOrder();
                final int objectCount = AbstractTableLensComponent.this.model.getObjectCount();
                final int rowHeight = (int)Math.max(Math.ceil((double)height / (double)objectCount), 1.0);
                if (!g.isThreadSafe()) {
                    for (Object row : this.visualLayer) {
                        this.draw(g, row, height, axisOrder, objectCount, rowHeight);
                    }
                } else {
                    int nTasks = Math.min(executor.getAvailableProcessors(), this.visualLayer.getObjectCount());
                    int nRowsPerTask = this.visualLayer.getObjectCount() / nTasks;
                    ArrayList<2> todo = new ArrayList<2>(nTasks);
                    for (int nTask = 0; nTask < nTasks; ++nTask) {
                        final int fromRow = nTask * nRowsPerTask;
                        final int toRow = nTask < nTasks - 1 ? fromRow + nRowsPerTask : this.visualLayer.getObjectCount();
                        todo.add(new Callable<Object>(){
                            private final int from;
                            private final int to;
                            {
                                this.from = fromRow;
                                this.to = toRow;
                            }

                            @Override
                            public Object call() throws Exception {
                                for (Object row : AbstractVisualLayerIDrawing.this.visualLayer.iterable(this.from, this.to - 1)) {
                                    AbstractVisualLayerIDrawing.this.draw(g, row, height, axisOrder, objectCount, rowHeight);
                                }
                                return null;
                            }
                        });
                    }
                    try {
                        List answers = executor.getExecutor().invokeAll(todo);
                        for (Future answer : answers) {
                            try {
                                answer.get();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            catch (ExecutionException e) {
                                e.getCause().printStackTrace();
                            }
                        }
                    }
                    catch (InterruptedException answers) {
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        protected void draw(IGraphics g, Row row, int height, MutableVisibleOrder<AxisModel<Row, C>> axisOrder, int objectCount, int rowHeight) {
            int y = AbstractTableLensComponent.this.getY(row, objectCount, height);
            int axisCount = axisOrder.size();
            for (int i = 0; i < axisCount; ++i) {
                Number value;
                AxisModel xAxisModel = (AxisModel)axisOrder.get(i);
                Double x1Location = AbstractTableLensComponent.this.model.getLocation(xAxisModel);
                Double x2Location = i + 1 < axisCount ? AbstractTableLensComponent.this.model.getLocation((AxisModel)axisOrder.get(i + 1)) : Double.valueOf(1.0);
                if (x1Location == null || x2Location == null || (value = xAxisModel.getValue(row)) == null) continue;
                int cw = AbstractTableLensComponent.this.getWidth();
                int x = (int)(x1Location * (double)cw);
                int w = (int)((x2Location * (double)cw - (double)x) * 0.8);
                int width = (int)((double)w * xAxisModel.getNormalized(value.doubleValue()));
                width = Math.min(w, width);
                width = Math.max(1, width);
                this.draw(g, x, y, width, rowHeight, row);
            }
        }

        public abstract void draw(IGraphics var1, int var2, int var3, int var4, int var5, Row var6);
    }
}

