/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.Serializable;
import java.util.AbstractList;
import org.geotools.util.CheckedCollection;

public class UnmodifiableArrayList<E>
extends AbstractList<E>
implements CheckedCollection<E>,
Serializable {
    private static final long serialVersionUID = -3605810209653785967L;
    private final E[] array;

    @SafeVarargs
    protected UnmodifiableArrayList(E ... array) {
        this.array = array;
    }

    @SafeVarargs
    public static <E> UnmodifiableArrayList<E> wrap(E ... array) {
        return new UnmodifiableArrayList<E>(array);
    }

    @Override
    public Class<E> getElementType() {
        return this.array.getClass().getComponentType();
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public E get(int index) {
        return this.array[index];
    }

    @Override
    public int indexOf(Object object) {
        if (object == null) {
            for (int i = 0; i < this.array.length; ++i) {
                if (this.array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.array.length; ++i) {
                if (!object.equals(this.array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        int i = this.array.length;
        if (object == null) {
            while (--i >= 0 && this.array[i] != null) {
            }
        } else {
            while (--i >= 0 && !object.equals(this.array[i])) {
            }
        }
        return i;
    }

    @Override
    public boolean contains(Object object) {
        int i = this.array.length;
        if (object == null) {
            while (--i >= 0) {
                if (this.array[i] != null) continue;
                return true;
            }
        } else {
            while (--i >= 0) {
                if (!object.equals(this.array[i])) continue;
                return true;
            }
        }
        return false;
    }
}

