/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.propertytable;

import de.javasoft.combobox.table.BooleanComboBoxTableCellEditor;
import de.javasoft.combobox.table.BooleanComboBoxTableCellRenderer;
import de.javasoft.combobox.table.ColorComboBoxTableCellEditor;
import de.javasoft.combobox.table.ColorComboBoxTableCellRenderer;
import de.javasoft.combobox.table.FontComboBoxTableCellEditor;
import de.javasoft.combobox.table.FontComboBoxTableCellRenderer;
import de.javasoft.combobox.table.JYComboBoxTableCellEditor;
import de.javasoft.combobox.table.JYComboBoxTableCellRenderer;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.propertytable.table.DefaultPropertyTableModel;
import de.javasoft.propertytable.table.PropertyTableModel;
import de.javasoft.propertytable.ui.addons.JYPropertyTableAddon;
import de.javasoft.syntheticaaddons.SyntheticaAddons;
import de.javasoft.syntheticaaddons.table.CheckBoxTableCellEditor;
import de.javasoft.syntheticaaddons.table.CheckBoxTableCellRenderer;
import de.javasoft.syntheticaaddons.table.DateComboBoxTableCellEditor;
import de.javasoft.syntheticaaddons.table.DateComboBoxTableCellRenderer;
import de.javasoft.syntheticaaddons.table.HyperlinkTableCellRenderer;
import de.javasoft.syntheticaaddons.table.IntegerGroupTableCellEditor;
import de.javasoft.syntheticaaddons.table.IntegerGroupTableCellRenderer;
import de.javasoft.syntheticaaddons.table.NumberTableCellEditor;
import de.javasoft.syntheticaaddons.table.NumberTableCellRenderer;
import de.javasoft.syntheticaaddons.table.ObjectTableCellEditor;
import de.javasoft.syntheticaaddons.table.ObjectTableCellRenderer;
import de.javasoft.syntheticaaddons.table.SeparatorTableCellRenderer;
import de.javasoft.syntheticaaddons.table.SliderTableCellEditor;
import de.javasoft.syntheticaaddons.table.SliderTableCellRenderer;
import de.javasoft.syntheticaaddons.table.SpinnerTableCellEditor;
import de.javasoft.syntheticaaddons.table.SpinnerTableCellRenderer;
import de.javasoft.syntheticaaddons.table.TableSeparator;
import de.javasoft.syntheticaaddons.table.TextFieldTableCellEditor;
import de.javasoft.syntheticaaddons.table.UneditableTableCellEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.URL;
import java.util.Date;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.DefaultButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.plaf.ComponentAddon;

public class JYPropertyTable
extends JTable {
    private static final long serialVersionUID = -5094635508334830971L;
    protected TableCellRenderer defaultRenderer;
    protected TableCellEditor defaultEditor;
    private ObjectTableCellRenderer cellRenderer;
    private ObjectTableCellEditor cellEditor;
    private TableSeparator tableSeparator = new TableSeparator();

    static {
        SyntheticaAddons.contribute((ComponentAddon)new JYPropertyTableAddon());
    }

    public JYPropertyTable() {
        this(null);
    }

    public JYPropertyTable(PropertyTableModel model) {
        super(model);
        this.setRowSelectionAllowed(true);
    }

    @Override
    protected TableModel createDefaultDataModel() {
        return new DefaultPropertyTableModel();
    }

    @Override
    public PropertyTableModel getModel() {
        return (PropertyTableModel)super.getModel();
    }

    @Override
    public void setModel(TableModel model) {
        if (!(model instanceof PropertyTableModel)) {
            throw new IllegalArgumentException("Model type has to be an instance of " + PropertyTableModel.class);
        }
        super.setModel(model);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        int rh = SyntheticaLookAndFeel.getInt((String)"JYPropertyTable.relativeRowHeight", (Component)this, (int)3);
        this.setRowHeight(new JTable(0, 0).getRowHeight() + rh);
        this.installDefaultRenderer();
        this.installDefaultEditor();
        this.installRenderers();
        this.installEditors();
    }

    private void installDefaultRenderer() {
        this.defaultRenderer = this.getDefaultRenderer(Object.class);
        this.cellRenderer = new ObjectTableCellRenderer(this.defaultRenderer);
        this.setDefaultRenderer(Object.class, (TableCellRenderer)this.cellRenderer);
    }

    private void installDefaultEditor() {
        this.defaultEditor = this.getDefaultEditor(Object.class);
        this.cellEditor = new ObjectTableCellEditor(this.defaultEditor);
        this.setDefaultEditor(Object.class, (TableCellEditor)this.cellEditor);
    }

    protected void installRenderers() {
        this.setPropertyRenderer(Boolean.class, (TableCellRenderer)((Object)new BooleanComboBoxTableCellRenderer(this.defaultRenderer)));
        this.setPropertyRenderer(Integer.class, (TableCellRenderer)new NumberTableCellRenderer(this.defaultRenderer, Integer.class, 0, 0));
        this.setPropertyRenderer(Long.class, (TableCellRenderer)new NumberTableCellRenderer(this.defaultRenderer, Long.class, 0, 0));
        this.setPropertyRenderer(Float.class, (TableCellRenderer)new NumberTableCellRenderer(this.defaultRenderer, Float.class, 0, 4));
        this.setPropertyRenderer(Double.class, (TableCellRenderer)new NumberTableCellRenderer(this.defaultRenderer, Double.class, 0, 4));
        IntegerGroupTableCellRenderer integerRenderer = new IntegerGroupTableCellRenderer(this.defaultRenderer);
        this.setPropertyRenderer(Point.class, (TableCellRenderer)integerRenderer);
        this.setPropertyRenderer(Dimension.class, (TableCellRenderer)integerRenderer);
        this.setPropertyRenderer(Rectangle.class, (TableCellRenderer)integerRenderer);
        this.setPropertyRenderer(Insets.class, (TableCellRenderer)integerRenderer);
        this.setPropertyRenderer(Color.class, (TableCellRenderer)((Object)new ColorComboBoxTableCellRenderer(this.defaultRenderer)));
        this.setPropertyRenderer(Date.class, (TableCellRenderer)new DateComboBoxTableCellRenderer(this.defaultRenderer));
        this.setPropertyRenderer(Font.class, (TableCellRenderer)((Object)new FontComboBoxTableCellRenderer(this.defaultRenderer)));
        this.setPropertyRenderer(DefaultComboBoxModel.class, (TableCellRenderer)((Object)new JYComboBoxTableCellRenderer(this.defaultRenderer)));
        CheckBoxTableCellRenderer cr = new CheckBoxTableCellRenderer(this.defaultRenderer);
        this.setPropertyRenderer(DefaultButtonModel.class, (TableCellRenderer)cr);
        this.setPropertyRenderer(SpinnerNumberModel.class, (TableCellRenderer)new SpinnerTableCellRenderer(this.defaultRenderer));
        this.setPropertyRenderer(DefaultBoundedRangeModel.class, (TableCellRenderer)new SliderTableCellRenderer(this.defaultRenderer));
        this.setPropertyRenderer(TableSeparator.class, (TableCellRenderer)new SeparatorTableCellRenderer(this.defaultRenderer));
        this.setPropertyRenderer(URL.class, (TableCellRenderer)new HyperlinkTableCellRenderer(this.defaultRenderer));
    }

    protected void installEditors() {
        this.setPropertyEditor(Boolean.class, (TableCellEditor)((Object)new BooleanComboBoxTableCellEditor(this.defaultEditor)));
        this.setPropertyEditor(Integer.class, (TableCellEditor)new NumberTableCellEditor(this.defaultEditor, Integer.class, 0, 0));
        this.setPropertyEditor(Long.class, (TableCellEditor)new NumberTableCellEditor(this.defaultEditor, Long.class, 0, 0));
        this.setPropertyEditor(Float.class, (TableCellEditor)new NumberTableCellEditor(this.defaultEditor, Float.class, 0, 4));
        this.setPropertyEditor(Double.class, (TableCellEditor)new NumberTableCellEditor(this.defaultEditor, Double.class, 0, 4));
        this.setPropertyEditor(String.class, (TableCellEditor)new TextFieldTableCellEditor(this.defaultEditor));
        this.setPropertyEditor(Point.class, (TableCellEditor)new IntegerGroupTableCellEditor(this.defaultEditor, Point.class, 2));
        this.setPropertyEditor(Dimension.class, (TableCellEditor)new IntegerGroupTableCellEditor(this.defaultEditor, Dimension.class, 2));
        this.setPropertyEditor(Rectangle.class, (TableCellEditor)new IntegerGroupTableCellEditor(this.defaultEditor, Rectangle.class, 4));
        this.setPropertyEditor(Insets.class, (TableCellEditor)new IntegerGroupTableCellEditor(this.defaultEditor, Insets.class, 4));
        boolean editable = SyntheticaLookAndFeel.getBoolean((String)"JYPropertyTable.comboBoxEditor.editable", (Component)this, (boolean)true);
        this.setPropertyEditor(Color.class, (TableCellEditor)((Object)new ColorComboBoxTableCellEditor(this.defaultEditor, editable, false, false)));
        this.setPropertyEditor(Date.class, (TableCellEditor)new DateComboBoxTableCellEditor(this.defaultEditor, editable, false));
        this.setPropertyEditor(Font.class, (TableCellEditor)((Object)new FontComboBoxTableCellEditor(this.defaultEditor, editable, false)));
        this.setPropertyEditor(DefaultComboBoxModel.class, (TableCellEditor)((Object)new JYComboBoxTableCellEditor(this.defaultEditor, editable, true)));
        CheckBoxTableCellEditor cb_ed = new CheckBoxTableCellEditor(this.defaultEditor);
        this.setPropertyEditor(DefaultButtonModel.class, (TableCellEditor)cb_ed);
        this.setPropertyEditor(SpinnerNumberModel.class, (TableCellEditor)new SpinnerTableCellEditor(this.defaultEditor));
        this.setPropertyEditor(DefaultBoundedRangeModel.class, (TableCellEditor)new SliderTableCellEditor(this.defaultEditor));
        this.setPropertyEditor(TableSeparator.class, (TableCellEditor)new UneditableTableCellEditor(this.defaultEditor));
        this.setPropertyEditor(URL.class, (TableCellEditor)new UneditableTableCellEditor(this.defaultEditor));
    }

    public TableCellRenderer getDefaultRenderer() {
        return this.defaultRenderer;
    }

    public TableCellEditor getDefaultEditor() {
        return this.defaultEditor;
    }

    public void setPropertyRenderer(Class<?> clazz, TableCellRenderer renderer) {
        if (renderer == null) {
            this.cellRenderer.removeRenderer(clazz);
        } else {
            this.cellRenderer.addRenderer(clazz, renderer);
        }
    }

    public TableCellRenderer getPropertyRenderer(Class<?> clazz) {
        return this.cellRenderer.getRenderer(clazz);
    }

    public void setPropertyRenderer(Object propertyKey, TableCellRenderer renderer) {
        int row = this.getModel().getPropertyRow(propertyKey);
        if (renderer == null) {
            this.cellRenderer.removeRenderer(row, 1);
        } else {
            this.cellRenderer.addRenderer(row, 1, renderer);
        }
    }

    public TableCellRenderer getPropertyRenderer(Object propertyKey) {
        int row = this.getModel().getPropertyRow(propertyKey);
        return this.cellRenderer.getRenderer(row, 1);
    }

    public void setPropertyEditor(Class<?> clazz, TableCellEditor editor) {
        if (editor == null) {
            this.cellEditor.removeEditor(clazz);
        } else {
            this.cellEditor.addEditor(clazz, editor);
        }
    }

    public TableCellEditor getPropertyEditor(Class<?> clazz) {
        return this.cellEditor.getEditor(clazz);
    }

    public void setPropertyEditor(Object propertyKey, TableCellEditor editor) {
        int row = this.getModel().getPropertyRow(propertyKey);
        if (editor == null) {
            this.cellEditor.removeEditor(row, 1);
        } else {
            this.cellEditor.addEditor(row, 1, editor);
        }
    }

    public TableCellEditor getPropertyEditor(Object propertyKey) {
        int row = this.getModel().getPropertyRow(propertyKey);
        return this.cellEditor.getEditor(row, 1);
    }

    public void addProperty(Object key, Object value) {
        this.getModel().setProperty(this.getRowCount(), key, value);
    }

    public void removeProperty(int row) {
        this.getModel().removeProperty(row);
    }

    public void addSeparator() {
        this.addProperty(this.tableSeparator, this.tableSeparator);
    }
}

