/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.widgets;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class HorizontalLayout
implements LayoutManager {
    private int gap;

    public HorizontalLayout() {
        this(0);
    }

    public HorizontalLayout(int gap) {
        this.gap = gap;
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        Dimension size = parent.getSize();
        int height = size.height - insets.top - insets.bottom;
        if (parent.getComponentOrientation().isLeftToRight()) {
            int x = insets.left;
            int i = 0;
            int n = parent.getComponentCount();
            while (i < n) {
                Component c = parent.getComponent(i);
                if (c.isVisible()) {
                    int width = c.getPreferredSize().width;
                    c.setBounds(x, insets.top, width, height);
                    x += width + this.gap;
                }
                ++i;
            }
        } else {
            int x = parent.getSize().width - insets.right;
            int i = 0;
            int n = parent.getComponentCount();
            while (i < n) {
                Component c = parent.getComponent(i);
                if (c.isVisible()) {
                    int width = c.getPreferredSize().width;
                    c.setBounds(x -= width, insets.top, width, height);
                    x -= this.gap;
                }
                ++i;
            }
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(0, 0);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        Dimension pref = new Dimension(0, 0);
        int i = 0;
        int n = parent.getComponentCount();
        while (i < n) {
            Component c = parent.getComponent(i);
            if (c.isVisible()) {
                Dimension cpref = c.getPreferredSize();
                pref.height = Math.max(pref.height, cpref.height);
                pref.width += cpref.width + this.gap;
            }
            ++i;
        }
        pref.width += insets.left + insets.right;
        pref.height += insets.top + insets.bottom;
        return pref;
    }

    @Override
    public void addLayoutComponent(String name, Component c) {
    }

    @Override
    public void removeLayoutComponent(Component c) {
    }
}

