/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.document;

import com.macrofocus.application.high_d.document.ColorSettingsPanel;
import com.macrofocus.application.high_d.document.HighDConfigurationPanel;
import com.macrofocus.application.high_d.document.HighDDocument;
import com.macrofocus.application.high_d.document.HighDView;
import com.macrofocus.application.high_d.document.RenderingSettingsPanel;
import com.macrofocus.colormap.editor.ColorMapEditorFactory;
import com.macrofocus.colormapping.MutableColorMapping;
import com.macrofocus.common.collection.Iterables;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPComboBox;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.CPFormPanel;

public class DefaultConfigurationPanel<Column, Component, Color, Font>
implements HighDConfigurationPanel<Component> {
    private final CPFactory<Component, Font, ?, Color> factory;
    private final HighDDocument document;
    private final HighDView<?, ?> view;
    private final ColorMapEditorFactory colorMapEditorFactory;
    private final CPFormPanel<Component> formPanel;
    private final CPComponent<Component> nativeComponent;

    public DefaultConfigurationPanel(CPFactory<Component, Font, ?, Color> factory, HighDDocument document, HighDView<?, ?> view, ColorMapEditorFactory colorMapEditorFactory) {
        this.factory = factory;
        this.document = document;
        this.view = view;
        this.colorMapEditorFactory = colorMapEditorFactory;
        this.formPanel = factory.createFormPanel();
        MutableColorMapping colormapping = view.getHighDFactory().getVisual().getColorMapping();
        Iterable columns = Iterables.concatenate((Iterable[])new Iterable[]{Iterables.forArray((Object[])new String[]{null}), view.getHighDFactory().getDataFrame().columns()});
        this.formPanel.add((CPComponent)factory.createLabel("Color:"), (CPComponent)factory.createComboBox(colormapping.getColorSelection(), columns), this.createColorSettings());
        CPComboBox renderingComboBox = factory.createComboBox(document.getSettings().getRendering(), Iterables.forArray((Object[])CPCanvas.Rendering.values()));
        this.formPanel.add((CPComponent)factory.createLabel("Rendering:"), (CPComponent)renderingComboBox, this.createRenderingSettings());
        this.formPanel.addSeparator();
        this.nativeComponent = this.formPanel;
    }

    public CPComponent<Component> createRenderingSettings() {
        return new RenderingSettingsPanel(this.factory, this.document).getPanel();
    }

    public CPComponent<Component> createColorSettings() {
        return new ColorSettingsPanel(this.document, this.view, this.factory, this.colorMapEditorFactory).getPanel();
    }

    @Override
    public CPComponent<Component> getMainComponent() {
        return this.nativeComponent;
    }
}

