/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.document.persistence;

import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.application.SimpleVersionModel;
import com.macrofocus.application.VersionModel;
import com.macrofocus.application.high_d.document.HighDDocument;
import com.macrofocus.common.logging.Logging;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.format.FormatFactory;
import com.macrofocus.hierarchy.Hierarchy;
import com.macrofocus.high_d.HighDSettings;
import com.macrofocus.high_d.axis.Alignment;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.parallelcoordinates.geometry.Geometry;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.CPFontFactory;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.palette.PaletteFactory;
import com.macrofocus.persistence.Attribute;
import com.macrofocus.persistence.Element;
import com.macrofocus.persistence.ElementFactory;
import com.macrofocus.persistence.Elements;
import java.awt.Dimension;
import java.util.HashMap;

public class HighDPersistence<Color, Font, File> {
    private final HighDDocument<Color, Font, File> document;
    private final DataFrame<Integer, String, ?> dataFrame;
    private final CPColorFactory<Color> colorFactory;
    private final CPFontFactory<Font> fontFactory;
    private final PaletteFactory<Color> paletteFactory;
    private final FormatFactory formatFactory;
    private final ElementFactory elementFactory;

    public HighDPersistence(HighDDocument<Color, Font, File> document, CPColorFactory<Color> colorFactory, CPFontFactory<Font> fontFactory, PaletteFactory<Color> paletteFactory, FormatFactory formatFactory, ElementFactory elementFactory) {
        this.document = document;
        this.dataFrame = document.getDataFrame();
        this.colorFactory = colorFactory;
        this.fontFactory = fontFactory;
        this.paletteFactory = paletteFactory;
        this.formatFactory = formatFactory;
        this.elementFactory = elementFactory;
    }

    public void load(Element root) {
        block15: {
            boolean updateGroupBy = true;
            try {
                if (!root.getLocalName().equals("High-D") && !root.getLocalName().equals("ProfilePlot") && !root.getLocalName().equals("ll-coords")) break block15;
                Attribute versionAttribute = root.getAttribute("version");
                VersionModel version = null;
                if (versionAttribute != null) {
                    try {
                        version = new SimpleVersionModel(versionAttribute.getValue());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (version == null) {
                    version = ApplicationModelFactory.HIGHD_API.getVersionModel();
                }
                Elements children = root.getChildElements();
                for (int h = 0; h < children.size(); ++h) {
                    Element child = children.get(h);
                    if (child.getLocalName().equals("Options")) {
                        Elements options = child.getChildElements();
                        for (int i = 0; i < options.size(); ++i) {
                            Attribute visibleAttribute;
                            Element option = options.get(i);
                            if (!option.getLocalName().equals("Logo") || (visibleAttribute = option.getAttribute("visible")) == null) continue;
                            boolean bl = Boolean.valueOf(visibleAttribute.getValue());
                        }
                    }
                    if (child.getLocalName().equals("Settings")) {
                        String allowScrolling;
                        String rendering;
                        String antialiasing;
                        String geometry;
                        String showFiltered = child.getAttributeValue(HighDSettings.PropertyType.showFiltered.name());
                        if (showFiltered != null) {
                            this.document.getSettings().getShowFiltered().setValue((Object)Boolean.parseBoolean(showFiltered));
                        }
                        if ((geometry = child.getAttributeValue(HighDSettings.PropertyType.geometry.name())) != null) {
                            this.document.getSettings().getGeometry().setValue((Object)Geometry.valueOf((String)geometry));
                        }
                        if ((antialiasing = child.getAttributeValue(HighDSettings.PropertyType.antialiasing.name())) != null) {
                            this.document.getSettings().getAntialiasing().setValue((Object)Boolean.parseBoolean(antialiasing));
                        }
                        if ((rendering = child.getAttributeValue(HighDSettings.PropertyType.rendering.name())) != null) {
                            this.document.getSettings().getRendering().setValue((Object)CPCanvas.Rendering.valueOf((String)rendering));
                        }
                        if ((allowScrolling = child.getAttributeValue(HighDSettings.PropertyType.allowScrolling.name())) != null) {
                            this.document.getSettings().getAllowScrolling().setValue((Object)Boolean.parseBoolean(allowScrolling));
                        }
                    }
                    if (!child.getLocalName().equals("Variables")) continue;
                    this.loadAxesHierarchy(child, (AxisGroupModel<Integer, String>)((AxisGroupModel)this.document.getAxisHierarchy().getAxisGroupHierarchy().getRoot()), (AxisGroupModel<Integer, String>)((AxisGroupModel)this.document.getAxisHierarchy().getAxisGroupHierarchy().getRoot()));
                }
            }
            catch (Exception e) {
                Logging.getInstance().process((Throwable)e);
            }
        }
    }

    private void loadAxesHierarchy(Element child, AxisGroupModel<Integer, String> rootAxis, AxisGroupModel<Integer, String> parent) {
        String name;
        String indexString;
        Element variable;
        int i;
        HashMap<String, AxisGroupModel> groups = new HashMap<String, AxisGroupModel>();
        Elements variables = child.getChildElements();
        for (i = 0; i < variables.size(); ++i) {
            String maximum;
            String minimum;
            String hidden;
            variable = variables.get(i);
            if (variable.getLocalName().equals("Group")) {
                String collapsed;
                String name2 = variable.getAttributeValue("name");
                AxisGroupModel axisGroupModel = this.document.getAxisHierarchy().createGroup(parent, name2, new AxisModel[0]);
                String collapsible = variable.getAttributeValue("collapsible");
                if (collapsible != null) {
                    axisGroupModel.setCollapsible(Boolean.parseBoolean(collapsible));
                }
                if ((collapsed = variable.getAttributeValue("collapsed")) != null) {
                    axisGroupModel.setCollapsed(Boolean.parseBoolean(collapsed));
                }
                groups.put(name2, axisGroupModel);
                this.loadAxesHierarchy(variable, rootAxis, (AxisGroupModel<Integer, String>)axisGroupModel);
                continue;
            }
            if (!variable.getLocalName().equals("Variable")) continue;
            indexString = variable.getAttributeValue("index");
            name = variable.getAttributeValue("name");
            int index = indexString != null ? Integer.parseInt(indexString) : this.dataFrame.getColumnAddress((Object)name);
            if (index < 0) {
                System.err.println("Could not find " + name);
                continue;
            }
            AxisModel axisModel = this.document.getAxisHierarchy().getAxisModel((Object)name);
            AxisGroupModel axisGroupModel = parent;
            if (axisModel != null && axisGroupModel != null) {
                String group = variable.getAttributeValue("group");
                if (group != null) {
                    axisGroupModel = (AxisGroupModel)groups.get(group);
                }
                if (rootAxis != axisGroupModel) {
                    this.document.getAxisHierarchy().moveToGroup(rootAxis, axisGroupModel, axisModel);
                }
            }
            if ((hidden = variable.getAttributeValue("hidden")) != null && axisModel != null) {
                axisGroupModel.getAxisOrder().setVisible((Object)axisModel, !Boolean.parseBoolean(hidden));
            }
            if ((minimum = variable.getAttributeValue("min")) != null && axisModel != null) {
                axisModel.setMinimum(Double.parseDouble(minimum));
                axisModel.getInterval().setValue(axisModel.getMinimum(), axisModel.getMaximum() - axisModel.getMinimum());
            }
            if ((maximum = variable.getAttributeValue("max")) == null || axisModel == null) continue;
            axisModel.setMaximum(Double.parseDouble(maximum));
            axisModel.getInterval().setValue(axisModel.getMinimum(), axisModel.getMaximum() - axisModel.getMinimum());
        }
        for (i = 0; i < variables.size(); ++i) {
            variable = variables.get(i);
            if (!variable.getLocalName().equals("Variable")) continue;
            indexString = variable.getAttributeValue("index");
            name = variable.getAttributeValue("name");
            int index = indexString != null ? Integer.parseInt(indexString) : this.dataFrame.getColumnAddress((Object)name);
            if (index < 0) {
                System.err.println("Could not find " + name);
                continue;
            }
            String location = variable.getAttributeValue("location");
            if (location == null) continue;
            AxisModel axisModel = this.document.getAxisHierarchy().getAxisModel((Object)name);
            if (axisModel != null) {
                this.document.getParallelCoordinatesModel().getAxisLocations(this.document.getAxisHierarchy().getAxisGroup(axisModel)).setLocation(Alignment.Center, axisModel, Double.parseDouble(location));
                continue;
            }
            System.err.println("Could not find " + name);
        }
    }

    public void save(Element root, File file) {
        Element element;
        if (this.document.getDataSourcePersistence() != null && (element = this.document.getDataSourcePersistence().create(file)) != null) {
            root.appendChild(element);
        }
        Element options = this.elementFactory.newElement("Options");
        Element logoElement = this.elementFactory.newElement("Logo");
        logoElement.addAttribute(this.elementFactory.newAttribute("visible", Boolean.toString(this.document.isLogoVisible)));
        options.appendChild(logoElement);
        root.appendChild(options);
        Element settings = this.elementFactory.newElement("Settings");
        this.saveGeneralSettings(settings);
        root.appendChild(settings);
        Element variables = this.elementFactory.newElement("Variables");
        Hierarchy axisGroupHierarchy = this.document.getAxisHierarchy().getAxisGroupHierarchy();
        this.saveAxes(variables, (Hierarchy<AxisGroupModel<Integer, String>>)axisGroupHierarchy, (AxisGroupModel<Integer, String>)((AxisGroupModel)axisGroupHierarchy.getRoot()));
        root.appendChild(variables);
    }

    private void saveAxes(Element variables, Hierarchy<AxisGroupModel<Integer, String>> axisGroupHierarchy, AxisGroupModel<Integer, String> axisGroup) {
        for (AxisModel axisModel : axisGroup.getAxisModels()) {
            String c = (String)axisModel.getColumn();
            Element variableElement = this.elementFactory.newElement("Variable");
            variableElement.addAttribute(this.elementFactory.newAttribute("index", Integer.toString(this.document.getDataFrame().getColumnAddress((Object)c))));
            variableElement.addAttribute(this.elementFactory.newAttribute("name", this.document.getDataFrame().getColumnName((Object)c)));
            variableElement.addAttribute(this.elementFactory.newAttribute("hidden", Boolean.toString(this.document.getParallelCoordinatesModel().isHidden(axisModel))));
            Double location = this.document.getParallelCoordinatesModel().getAxisLocations(this.document.getAxisHierarchy().getAxisGroup(axisModel)).getLocation(Alignment.Center, axisModel);
            if (location != null) {
                variableElement.addAttribute(this.elementFactory.newAttribute("location", Double.toString(location)));
            }
            variableElement.addAttribute(this.elementFactory.newAttribute("min", Double.toString(axisModel.getMinimum())));
            variableElement.addAttribute(this.elementFactory.newAttribute("max", Double.toString(axisModel.getMaximum())));
            variables.appendChild(variableElement);
        }
        for (AxisGroupModel child : axisGroupHierarchy.getChildren(axisGroup)) {
            Element groupElement = this.elementFactory.newElement("Group");
            groupElement.addAttribute(this.elementFactory.newAttribute("name", child.getName()));
            groupElement.addAttribute(this.elementFactory.newAttribute("collapsible", Boolean.toString(child.isCollapsible())));
            groupElement.addAttribute(this.elementFactory.newAttribute("collapsed", Boolean.toString(child.isCollapsed())));
            variables.appendChild(groupElement);
            this.saveAxes(groupElement, axisGroupHierarchy, (AxisGroupModel<Integer, String>)child);
        }
    }

    private void saveGeneralSettings(Element root) {
        HighDSettings.PropertyType[] keys;
        for (HighDSettings.PropertyType key : keys = new HighDSettings.PropertyType[]{HighDSettings.PropertyType.showFiltered, HighDSettings.PropertyType.geometry, HighDSettings.PropertyType.antialiasing, HighDSettings.PropertyType.rendering, HighDSettings.PropertyType.allowScrolling}) {
            Object value = this.getValue(key);
            if (value == null) continue;
            Object stringValue = null;
            if (value instanceof String) {
                stringValue = (String)value;
            } else if (value instanceof Boolean) {
                stringValue = Boolean.toString((Boolean)value);
            } else if (value instanceof Integer) {
                stringValue = Integer.toString((Integer)value);
            } else if (value instanceof Float) {
                stringValue = Float.toString(((Float)value).floatValue());
            } else if (value instanceof Double) {
                stringValue = Double.toString((Double)value);
            } else if (value instanceof Dimension) {
                Dimension dimension = (Dimension)value;
                stringValue = dimension.width + "; " + dimension.height;
            } else {
                stringValue = value.toString();
            }
            if (stringValue == null) continue;
            root.addAttribute(this.elementFactory.newAttribute(key.name(), (String)stringValue));
        }
    }

    private Object getValue(HighDSettings.PropertyType key) {
        if (this.document.getSettings().getProperties().getProperty((Object)key) != null) {
            return this.document.getSettings().getProperties().getValue((Object)key);
        }
        throw new UnsupportedOperationException("Key " + String.valueOf(key) + " unknonw");
    }
}

