/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JComponent;

public class ButtonBar
extends JComponent {
    private static final long serialVersionUID = -8995510780386573538L;
    public static final String uiClassID = "ButtonBarUI";
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static final String POS_KEY = "JButton.segmentPosition";
    private static final String ONLY = "only";
    private static final String FIRST = "first";
    private static final String MIDDLE = "middle";
    private static final String LAST = "last";
    private int orientation = 0;
    private String styleName = null;

    public ButtonBar() {
        this(0);
    }

    public ButtonBar(int orientation) {
        this.orientation = orientation;
        if (orientation == 0) {
            this.setLayout(new ButtonBarLayout(this, 2));
        } else {
            this.setLayout(new ButtonBarLayout(this, 3));
        }
        this.setName("ButtonBar");
    }

    public void setButtonStyleName(String styleName) {
        this.styleName = styleName;
    }

    @Override
    public Component add(Component comp) {
        return this.addButton((AbstractButton)comp);
    }

    public AbstractButton addButton(AbstractButton button) {
        button.getMaximumSize();
        Component[] buttons = this.getComponents();
        int size = buttons.length;
        String segPos = null;
        if (size == 0) {
            segPos = ONLY;
        } else if (size >= 1) {
            segPos = LAST;
            AbstractButton b = (AbstractButton)buttons[size - 1];
            if (size == 1) {
                b.putClientProperty(POS_KEY, FIRST);
            } else {
                b.putClientProperty(POS_KEY, MIDDLE);
            }
        }
        button.putClientProperty(POS_KEY, segPos);
        if (this.styleName != null) {
            button.putClientProperty("Synthetica.style", this.styleName);
        }
        button.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JComponent c;
                String segPos;
                if ("componentOrientation".equals(evt.getPropertyName()) && ((segPos = (String)(c = (JComponent)evt.getSource()).getClientProperty(ButtonBar.POS_KEY)).equals(ButtonBar.FIRST) || segPos.equals(ButtonBar.LAST))) {
                    c.putClientProperty(ButtonBar.POS_KEY, segPos.equals(ButtonBar.FIRST) ? ButtonBar.LAST : ButtonBar.FIRST);
                }
            }
        });
        super.add(button);
        return button;
    }

    @Override
    public void remove(Component comp) {
        this.removeButton((AbstractButton)comp);
    }

    public void removeButton(AbstractButton button) {
        Component[] buttons = this.getComponents();
        int size = buttons.length;
        int idx = 0;
        Component[] componentArray = buttons;
        int n = buttons.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c == button) break;
            ++idx;
            ++n2;
        }
        if (size == idx) {
            return;
        }
        String segPos = null;
        AbstractButton b = null;
        if (size == 2) {
            segPos = ONLY;
            b = idx == 0 ? (AbstractButton)buttons[1] : (AbstractButton)buttons[0];
        } else if (size > 2) {
            if (idx == 0) {
                segPos = FIRST;
                b = (AbstractButton)buttons[idx + 1];
            } else if (idx == size - 1) {
                segPos = LAST;
                b = (AbstractButton)buttons[idx - 1];
            }
        }
        if (b != null) {
            b.putClientProperty(POS_KEY, segPos);
        }
        super.remove(button);
    }

    public int getOrientation() {
        return this.orientation;
    }

    private class ButtonBarLayout
    extends BoxLayout {
        public ButtonBarLayout(Container target, int axis) {
            super(target, axis);
        }

        @Override
        public void layoutContainer(Container target) {
            Rectangle r;
            Component c;
            super.layoutContainer(target);
            Rectangle maxRect = new Rectangle();
            Component[] componentArray = target.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                c = componentArray[n2];
                r = c.getBounds();
                maxRect = ButtonBar.this.getOrientation() == 0 ? (r.height > maxRect.height ? r : maxRect) : (r.width > maxRect.width ? r : maxRect);
                ++n2;
            }
            componentArray = target.getComponents();
            n = componentArray.length;
            n2 = 0;
            while (n2 < n) {
                c = componentArray[n2];
                r = c.getBounds();
                if (ButtonBar.this.getOrientation() == 0) {
                    r.y = maxRect.y;
                    r.height = maxRect.height;
                } else {
                    r.x = maxRect.x;
                    r.width = maxRect.width;
                }
                c.setBounds(r);
                ++n2;
            }
        }
    }
}

