/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.DockingUtility;
import de.javasoft.docking.controls.DragManager;
import de.javasoft.docking.controls.DragOperation;
import de.javasoft.docking.controls.DragOutlinePreview;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.IDockingPort;
import de.javasoft.docking.controls.IDragPreview;
import de.javasoft.docking.controls.NestedComponents;
import de.javasoft.docking.controls.RootWindow;
import de.javasoft.tabpane.JYTabbedPane;
import de.javasoft.widgets.util.WidgetUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

class DragGlassPane
extends JComponent {
    private static final long serialVersionUID = -837777168697616982L;
    private NestedComponents currentDropTargets;
    private Component cachedGlassPane;
    private RootWindow rootWindow;
    private IDragPreview previewDelegate;
    private Polygon previewPoly;
    private DragOperation currentDragOperation;

    public DragGlassPane() {
        this.setLayout(null);
    }

    public void clear() {
        this.currentDropTargets = null;
        this.currentDragOperation = null;
        this.repaint();
    }

    public Component getCachedGlassPane() {
        return this.cachedGlassPane;
    }

    public RootWindow getRootWindow() {
        return this.rootWindow;
    }

    public void setCachedGlassPane(Component cachedGlassPane) {
        this.cachedGlassPane = cachedGlassPane;
    }

    public void setRootWindow(RootWindow rootWindow) {
        this.rootWindow = rootWindow;
    }

    private NestedComponents getDropTargets(DragOperation dragOp) {
        Container c = this.rootWindow.getContentPane();
        Point currMouse = dragOp.getCurrentMouse(c);
        Component deep = SwingUtilities.getDeepestComponentAt(c, currMouse.x, currMouse.y);
        return NestedComponents.find(deep, IDockable.class, IDockingPort.class);
    }

    public void processDragEvent(DragOperation dragOp) {
        this.currentDragOperation = dragOp;
        NestedComponents dropTargets = this.getDropTargets(dragOp);
        if (this.currentDropTargets == null && dropTargets == null || dropTargets == null) {
            dragOp.setTarget(null, "UNKNOWN");
            this.currentDragOperation = null;
            this.repaint();
            return;
        }
        IDockingPort port = (IDockingPort)((Object)dropTargets.parent);
        if (port == null) {
            dragOp.setTarget(null, "UNKNOWN");
            this.currentDragOperation = null;
            this.repaint();
            return;
        }
        this.currentDropTargets = dropTargets;
        IDockable hover = this.getHoverDockable(dropTargets);
        Point mousePoint = dragOp.getCurrentMouse(port.getComponent());
        String region = this.findRegion(port, hover, mousePoint);
        int dropTabIndex = -1;
        if (DockingManager.isTabReorderByDraggingEnabled() && hover != null) {
            Container parent = hover.getComponent().getParent();
            if (region == "CENTER" && (parent instanceof JTabbedPane || parent != null && parent.getParent() instanceof JYTabbedPane)) {
                JTabbedPane tabPane = parent instanceof JTabbedPane ? (JTabbedPane)parent : (JTabbedPane)parent.getParent();
                Point p = SwingUtilities.convertPoint(port.getComponent(), mousePoint, tabPane);
                int i = 0;
                while (i < tabPane.getTabCount()) {
                    if (tabPane.getBoundsAt(i).contains(p)) {
                        dropTabIndex = i;
                        break;
                    }
                    ++i;
                }
            }
        }
        dragOp.setDropTabIndex(dropTabIndex);
        if (!port.isDockingAllowed(dragOp.getDockableReference().getComponent(), region)) {
            region = "UNKNOWN";
        }
        dragOp.setTarget(port, region);
        this.previewPoly = this.createPreviewPolygon(dragOp, port, hover, region);
        this.repaint();
    }

    private String findRegion(IDockingPort hoverPort, IDockable hoverDockable, Point mousePoint) {
        if (hoverPort == null) {
            return "UNKNOWN";
        }
        if (hoverDockable != null) {
            return hoverPort.getRegion(mousePoint);
        }
        JComponent docked = hoverPort.getDockedComponent();
        if (docked == null) {
            return hoverPort.getRegion(mousePoint);
        }
        return "UNKNOWN";
    }

    private IDockable getHoverDockable(NestedComponents nest) {
        Component c;
        Component component = c = nest == null ? null : nest.child;
        if (c instanceof IDockable) {
            return (IDockable)((Object)c);
        }
        return DockingManager.getDockable(c);
    }

    protected Polygon createPreviewPolygon(DragOperation dragOp, IDockingPort port, IDockable hover, String region) {
        Map<Object, Object> dragContext = this.getDragContext(dragOp);
        if (dragOp != null && dragContext != null) {
            dragContext.put("DROP_TAB_INDEX", dragOp.getDropTabIndex());
        }
        JComponent dc = dragOp.getDockableComponent();
        return this.getPreviewDelegate(dc, port).createPreviewPolygon(dc, port, hover, region, this, dragContext);
    }

    private IDragPreview getPreviewDelegate(Component dockable, IDockingPort port) {
        if (this.previewDelegate == null) {
            this.previewDelegate = this.createPreview(UIManager.getString("JYDocking.dragPreview.className"));
        }
        return this.previewDelegate;
    }

    private IDragPreview createPreview(String className) {
        if (className == null) {
            className = DragOutlinePreview.class.getName();
        }
        return (IDragPreview)DockingUtility.createInstance(className, IDragPreview.class);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.currentDragOperation != null && this.previewDelegate != null && this.previewPoly != null) {
            this.getRootPane().setCursor(WidgetUtils.getDragCursor());
        } else {
            this.getRootPane().setCursor(WidgetUtils.getStopCursor());
        }
        if (this.currentDragOperation != null && this.previewDelegate != null && this.previewPoly != null) {
            IDockable dockable = this.currentDragOperation.getDockableReference();
            Map<Object, Object> dragInfo = this.getDragContext(this.currentDragOperation);
            this.previewDelegate.drawPreview((Graphics2D)g, this.previewPoly, dockable, dragInfo);
        }
    }

    private Map<Object, Object> getDragContext(DragOperation dragOp) {
        if (dragOp == null) {
            return null;
        }
        IDockable dockable = dragOp.getDockableReference();
        return DragManager.getDragContext(dockable);
    }
}

