/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.ILayoutNode;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

public class FloatingGroup
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -891385529699322982L;
    private String id;
    private HashSet<String> dockableIDs;
    private Rectangle windowBounds;
    private transient Window floatingWindow;
    private ILayoutNode restorationLayout;

    public FloatingGroup(String groupID) {
        this.id = groupID == null ? UUID.randomUUID().toString() : groupID;
        this.dockableIDs = new HashSet();
    }

    private FloatingGroup(String groupID, HashSet<String> dockableIDs) {
        this.id = groupID;
        this.dockableIDs = dockableIDs;
    }

    public void setFloatingWindow(Window floatingWindow) {
        this.floatingWindow = floatingWindow;
    }

    public Window getFloatingWindow() {
        return this.floatingWindow;
    }

    public void setBounds(Rectangle rect) {
        this.windowBounds = rect == null ? null : new Rectangle(rect);
    }

    public Rectangle getBounds() {
        return this.windowBounds == null ? null : (Rectangle)this.windowBounds.clone();
    }

    public String getID() {
        return this.id;
    }

    public void addDockable(String dockableID) {
        this.dockableIDs.add(dockableID);
    }

    public void removeDockable(String dockableID) {
        this.dockableIDs.remove(dockableID);
    }

    public boolean hasDockable(String dockableID) {
        return this.dockableIDs.contains(dockableID);
    }

    Iterator<String> getDockableIterator() {
        return this.dockableIDs.iterator();
    }

    public List<IDockable> getDockables() {
        ArrayList<IDockable> list = new ArrayList<IDockable>();
        for (String id : this.dockableIDs) {
            list.add(DockingManager.getDockable(id));
        }
        return list;
    }

    public boolean hasMaximizedDockable() {
        for (IDockable dockable : this.getDockables()) {
            if (!DockingManager.isMaximized(dockable)) continue;
            return true;
        }
        return false;
    }

    public int getDockableCount() {
        return this.dockableIDs.size();
    }

    public void destroy() {
        this.dockableIDs.clear();
        this.setFloatingWindow(null);
        this.setBounds(null);
    }

    ILayoutNode getRestorationLayout() {
        return this.restorationLayout;
    }

    void setRestorationLayout(ILayoutNode restorationLayout) {
        this.restorationLayout = restorationLayout;
    }

    public Object clone() {
        FloatingGroup clone = new FloatingGroup(this.id, new HashSet<String>(this.dockableIDs));
        clone.floatingWindow = this.floatingWindow;
        clone.windowBounds = this.windowBounds == null ? null : new Rectangle(this.windowBounds);
        clone.restorationLayout = this.restorationLayout;
        return clone;
    }
}

