/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.DockingUtility;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.RootWindow;
import java.awt.Component;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;

class NestedComponents {
    Component searchSrc;
    Component child;
    Component parent;

    public static NestedComponents find(Component searchSrc, Class<?> childClass, Class<?> parentClass) {
        if (searchSrc == null || childClass == null || parentClass == null) {
            return null;
        }
        NestedComponents nest = new NestedComponents(searchSrc, null, null);
        Component c = searchSrc;
        while (c != null && (!(c instanceof JRootPane) || c.getParent() instanceof JInternalFrame)) {
            if (nest.child == null && NestedComponents.isInstanceOf(c, childClass)) {
                nest.child = c;
            } else if (nest.child == null && c instanceof JTabbedPane && NestedComponents.isInstanceOf(((JTabbedPane)c).getSelectedComponent(), childClass)) {
                nest.child = ((JTabbedPane)c).getSelectedComponent();
            } else if (NestedComponents.isParentContainer(c, parentClass)) {
                nest.parent = c;
                break;
            }
            c = c.getParent();
        }
        return nest;
    }

    private static boolean isParentContainer(Component c, Class<?> parentClass) {
        if (parentClass == RootWindow.class) {
            return RootWindow.isValidRootContainer(c);
        }
        return parentClass.isAssignableFrom(c.getClass());
    }

    private static boolean isInstanceOf(Object obj, Class<?> clazz) {
        if (clazz.isAssignableFrom(obj.getClass())) {
            return true;
        }
        if (clazz == IDockable.class) {
            return DockingUtility.isDockable(obj);
        }
        return false;
    }

    private NestedComponents(Component searchSrc, Component child, Component parent) {
        this.searchSrc = searchSrc;
        this.child = child;
        this.parent = parent;
    }

    public boolean isFull() {
        return this.child != null && this.parent != null;
    }

    public int hashCode() {
        int h = this.searchSrc.hashCode();
        h += this.child == null ? 0 : this.child.hashCode();
        return h += this.parent == null ? 0 : this.parent.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NestedComponents)) {
            return false;
        }
        NestedComponents other = (NestedComponents)obj;
        return this.searchSrc == other.searchSrc && this.child == other.child && this.parent == other.parent;
    }
}

