/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.ui.controls;

import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.ui.controls.AbstractDockingViewAction;
import de.javasoft.docking.ui.controls.DockingButton;
import java.awt.event.ActionEvent;
import javax.swing.ButtonModel;
import javax.swing.UIManager;

public class DefaultMaximizeAction
extends AbstractDockingViewAction {
    private static final long serialVersionUID = 8925715857994576717L;

    public DefaultMaximizeAction(IDockable dockable) {
        super(dockable);
        this.putValue("ShortDescription", UIManager.get("JYDocking.titlebar.maximizeButton.toolTip"));
        this.putValue("ShortDescriptionselected", UIManager.get("JYDocking.titlebar.maximizeButton.selected.toolTip"));
    }

    @Override
    public void actionPerformed(IDockable dockable, ActionEvent evt) {
        boolean maximized = DockingManager.isMaximized(dockable);
        DockingManager.setMaximized(dockable, !maximized);
    }

    @Override
    public ButtonModel createButtonModel() {
        return new DockingButton.DockingButtonModel(){

            @Override
            public boolean isSelected() {
                IDockable d = DefaultMaximizeAction.this.getDockable();
                return d == null ? false : DockingManager.isMaximized(d);
            }
        };
    }
}

