/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.ui.controls;

import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.ui.controls.AbstractDockingViewAction;
import de.javasoft.docking.ui.controls.DockingButton;
import java.awt.event.ActionEvent;
import javax.swing.ButtonModel;
import javax.swing.UIManager;

public class DefaultMinimizeAction
extends AbstractDockingViewAction {
    private static final long serialVersionUID = -5523299582337235524L;
    private int placement = -1;

    public DefaultMinimizeAction(IDockable dockable) {
        this(dockable, -1);
    }

    public DefaultMinimizeAction(IDockable dockable, int placement) {
        super(dockable);
        this.placement = placement;
        this.putValue("ShortDescription", UIManager.get("JYDocking.titlebar.minimizeButton.toolTip"));
        this.putValue("ShortDescriptionselected", UIManager.get("JYDocking.titlebar.minimizeButton.selected.toolTip"));
    }

    @Override
    public void actionPerformed(IDockable dockable, ActionEvent evt) {
        boolean minimize = !DockingManager.isMinimized(dockable);
        DockingManager.setMinimized(dockable, minimize, this.placement);
    }

    @Override
    public ButtonModel createButtonModel() {
        return new DockingButton.DockingButtonModel(){

            @Override
            public boolean isSelected() {
                IDockable d = DefaultMinimizeAction.this.getDockable();
                return d == null ? false : DockingManager.isMinimized(d);
            }
        };
    }
}

