/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.button;

import com.macrofocus.button.ButtonEvent;
import com.macrofocus.button.ButtonListener;
import com.macrofocus.button.ButtonModel;
import com.macrofocus.button.ButtonView;
import com.macrofocus.color.ColorModel;
import com.macrofocus.color.RGBColorModel;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.UIManager;

public class SimpleButtonView
extends ButtonView {
    private final ButtonModel buttonModel;
    private String label;
    private int minimumWidth;
    private int minimumHeight;
    private boolean buttonDepressed = false;
    private Color backgroundColor;
    private Color lightColor;
    private Color darkColor;
    private Color textColor = Color.white;
    private Font font = new Font("Helvetica", 0, 12);
    private final String name;

    public SimpleButtonView(ButtonModel buttonModel, String label, PropertiesModel propertiesModel) {
        this(buttonModel, null, label, propertiesModel);
    }

    public SimpleButtonView(final ButtonModel buttonModel, String name, String label, final PropertiesModel propertiesModel) {
        this.buttonModel = buttonModel;
        this.label = label;
        this.name = name;
        this.updateProperties(propertiesModel);
        propertiesModel.addPropertiesListener(new PropertiesListener(){

            public void propertiesChanged(PropertiesEvent e) {
                SimpleButtonView.this.updateProperties(propertiesModel);
                SimpleButtonView.this.repaint();
            }
        });
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        this.minimumHeight = fontMetrics.getHeight() - fontMetrics.getLeading() + 3;
        this.minimumWidth = fontMetrics.stringWidth(label) + 6;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SimpleButtonView.this.updateScreenValues();
                SimpleButtonView.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SimpleButtonView.this.buttonDepressed = true;
                SimpleButtonView.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SimpleButtonView.this.buttonDepressed = false;
                SimpleButtonView.this.repaint();
                buttonModel.setSelected(this);
            }
        });
        buttonModel.addButtonListener(new ButtonListener(){

            @Override
            public void buttonSelected(ButtonEvent e) {
            }

            @Override
            public void buttonEnabledChanged(ButtonEvent event) {
            }

            @Override
            public void buttonStateChanged(ButtonEvent event) {
                SimpleButtonView.this.repaint();
            }
        });
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        if (!this.label.equals(label)) {
            this.label = label;
            FontMetrics fontMetrics = this.getFontMetrics(this.font);
            this.minimumHeight = fontMetrics.getHeight() - fontMetrics.getLeading() + 3;
            this.minimumWidth = fontMetrics.stringWidth(label) + 6;
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setFont(this.font);
        FontMetrics fontMetrics = g.getFontMetrics();
        if (this.buttonDepressed || this.buttonModel.isStateOn()) {
            g.setColor(this.darkColor);
            g.drawLine(0, 0, this.minimumWidth - 2, 0);
            g.drawLine(0, 0, 0, this.minimumHeight - 2);
            g.drawLine(0, this.minimumHeight - 1, this.minimumWidth - 1, this.minimumHeight - 1);
            g.drawLine(this.minimumWidth - 1, 0, this.minimumWidth - 1, this.minimumHeight - 1);
            g.setColor(this.textColor);
            g.drawString(this.label, 3, fontMetrics.getMaxAscent() + 1);
        } else {
            g.setColor(this.lightColor);
            g.drawLine(0, 0, this.minimumWidth - 2, 0);
            g.drawLine(0, 0, 0, this.minimumHeight - 2);
            g.setColor(this.darkColor);
            g.drawLine(1, this.minimumHeight - 2, this.minimumWidth - 2, this.minimumHeight - 2);
            g.drawLine(this.minimumWidth - 2, 1, this.minimumWidth - 2, this.minimumHeight - 2);
            g.setColor(Color.black);
            g.drawLine(0, this.minimumHeight - 1, this.minimumWidth - 1, this.minimumHeight - 1);
            g.drawLine(this.minimumWidth - 1, 0, this.minimumWidth - 1, this.minimumHeight - 1);
            g.setColor(this.textColor);
            g.drawString(this.label, 2, fontMetrics.getMaxAscent());
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.minimumWidth, this.minimumHeight);
    }

    protected void updateScreenValues() {
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        this.backgroundColor = ((ColorModel)propertiesModel.getValue(this.getClass(), this.name, "backgroundColor", (Object)new RGBColorModel(165, 183, 207))).getColor();
        this.lightColor = this.backgroundColor.brighter();
        this.darkColor = this.backgroundColor.darker();
        this.setBackground(this.backgroundColor);
        this.textColor = ((ColorModel)propertiesModel.getValue(this.getClass(), this.name, "textColor", (Object)new RGBColorModel(0, 0, 0))).getColor();
        this.font = UIManager.getFont("Tree.font");
    }
}

