/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.button.plaf;

import com.macrofocus.button.plaf.SimpleButtonBorder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;

public class SimpleCompactButtonUI
extends BasicButtonUI {
    private int minimumWidth;
    private int minimumHeight;

    public static ComponentUI createUI(JComponent c) {
        return new SimpleCompactButtonUI();
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setBorder(new SimpleButtonBorder());
    }

    @Override
    public void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new SimpleButtonListener(b);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        boolean isPressed = model.isPressed() && model.isArmed() || model.isSelected();
        Dimension size = b.getSize();
        if (c.getBackground() != null) {
            g.setColor(c.getBackground());
        }
        g.fillRect(0, 0, size.width, size.height);
        if (b.getText() != null) {
            g.setFont(c.getFont());
            FontMetrics fontMetrics = g.getFontMetrics();
            if (isPressed) {
                g.setColor(c.getForeground());
                g.drawString(b.getText(), 3, fontMetrics.getMaxAscent() + 1);
            } else {
                g.setColor(c.getForeground());
                g.drawString(b.getText(), 2, fontMetrics.getMaxAscent());
            }
        }
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        FontMetrics fontMetrics = b.getFontMetrics(c.getFont());
        this.minimumHeight = fontMetrics.getHeight() - fontMetrics.getLeading() + 3;
        this.minimumWidth = b.getText() != null ? fontMetrics.stringWidth(b.getText()) + 6 : 6;
        return new Dimension(this.minimumWidth, this.minimumHeight);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        FontMetrics fontMetrics = b.getFontMetrics(c.getFont());
        this.minimumHeight = fontMetrics.getHeight() - fontMetrics.getLeading() + 3;
        this.minimumWidth = b.getText() != null ? fontMetrics.stringWidth(b.getText()) + 6 : 6;
        return new Dimension(this.minimumWidth, this.minimumHeight);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    class SimpleButtonListener
    extends BasicButtonListener {
        public SimpleButtonListener(AbstractButton b) {
            super(b);
        }

        @Override
        public void focusGained(FocusEvent e) {
            Component c = (Component)e.getSource();
            c.repaint();
        }
    }
}

