/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.drawing.zoom;

import com.macrofocus.drawing.zoom.ZoomListener;
import com.macrofocus.drawing.zoom.ZoomStrategy;

public class CartesianFisheyeZoom
implements ZoomStrategy {
    private double focusXworld;
    private double focusYworld;
    private double focusWidthWorld;
    private double focusHeightWorld;
    private double zoomFactor;

    public CartesianFisheyeZoom() {
        this.focusXworld = 0.5;
        this.focusYworld = 0.5;
        this.focusWidthWorld = 0.0;
        this.focusHeightWorld = 0.0;
    }

    public CartesianFisheyeZoom(double focusXworld, double focusYworld, double focusWidthWorld, double focusHeightWorld, double zoomFactor) {
        this.focusXworld = focusXworld;
        this.focusYworld = focusYworld;
        this.focusWidthWorld = focusWidthWorld;
        this.focusHeightWorld = focusHeightWorld;
        this.zoomFactor = zoomFactor;
    }

    public void setZoomFactor(double zoomFactor) {
        this.zoomFactor = this.focusWidthWorld * zoomFactor > 1.0 ? 1.0 / this.focusWidthWorld : (this.focusHeightWorld * zoomFactor > 1.0 ? 1.0 / this.focusHeightWorld : zoomFactor);
    }

    public void setFocusXworld(double focusXworld) {
        this.focusXworld = focusXworld - this.focusWidthWorld / 2.0 < 0.0 ? this.focusWidthWorld / 2.0 : (focusXworld + this.focusWidthWorld / 2.0 > 1.0 ? 1.0 - this.focusWidthWorld / 2.0 : focusXworld);
    }

    public void setFocusYworld(double focusYworld) {
        this.focusYworld = focusYworld - this.focusHeightWorld / 2.0 < 0.0 ? this.focusHeightWorld / 2.0 : (focusYworld + this.focusHeightWorld / 2.0 > 1.0 ? 1.0 - this.focusHeightWorld / 2.0 : focusYworld);
    }

    public void setFocusWidthWorld(double focusWidthWorld) {
        this.focusWidthWorld = focusWidthWorld;
        if (this.focusXworld - focusWidthWorld / 2.0 < 0.0) {
            this.focusXworld = focusWidthWorld / 2.0;
        } else if (this.focusXworld + focusWidthWorld / 2.0 > 1.0) {
            this.focusXworld = 1.0 - focusWidthWorld / 2.0;
        }
    }

    public void setFocusHeightWorld(double focusHeightWorld) {
        this.focusHeightWorld = focusHeightWorld;
        if (this.focusYworld - focusHeightWorld / 2.0 < 0.0) {
            this.focusYworld = focusHeightWorld / 2.0;
        } else if (this.focusYworld + focusHeightWorld / 2.0 > 1.0) {
            this.focusYworld = 1.0 - focusHeightWorld / 2.0;
        }
    }

    @Override
    public double worldXToZoomedX(double x) {
        if (this.focusWidthWorld <= 0.0) {
            return x;
        }
        double[] boundaries = this.getWindowBoundaries(this.focusXworld, this.focusWidthWorld, this.zoomFactor);
        return this.focalTransformation(x, false, boundaries[0], boundaries[1], boundaries[2], boundaries[3]);
    }

    @Override
    public double worldYToZoomedY(double y) {
        if (this.focusHeightWorld <= 0.0) {
            return y;
        }
        double[] boundaries = this.getWindowBoundaries(this.focusYworld, this.focusHeightWorld, this.zoomFactor);
        return this.focalTransformation(y, false, boundaries[0], boundaries[1], boundaries[2], boundaries[3]);
    }

    @Override
    public double zoomedXToWorldX(double x) {
        if (this.focusWidthWorld <= 0.0) {
            return x;
        }
        double[] boundaries = this.getWindowBoundaries(this.focusXworld, this.focusWidthWorld, this.zoomFactor);
        return this.focalTransformation(x, true, boundaries[2], boundaries[3], boundaries[0], boundaries[1]);
    }

    @Override
    public double zoomedYToWorldY(double y) {
        if (this.focusHeightWorld <= 0.0) {
            return y;
        }
        double[] boundaries = this.getWindowBoundaries(this.focusYworld, this.focusHeightWorld, this.zoomFactor);
        return this.focalTransformation(y, true, boundaries[2], boundaries[3], boundaries[0], boundaries[1]);
    }

    private double focalTransformation(double value_raw, boolean back_transformation, double window_low_raw, double window_high_raw, double window_low_trans, double window_high_trans) {
        double exponent = back_transformation ? 1.0 / this.zoomFactor : this.zoomFactor;
        double value_trans = value_raw < window_low_raw ? Math.pow(value_raw / window_low_raw, exponent) * window_low_trans : (value_raw > window_high_raw ? (1.0 - Math.pow(1.0 - (value_raw - window_high_raw) / (1.0 - window_high_raw), exponent)) * (1.0 - window_high_trans) + window_high_trans : (value_raw - window_low_raw) / (window_high_raw - window_low_raw) * (window_high_trans - window_low_trans) + window_low_trans);
        return value_trans;
    }

    private double[] getWindowBoundaries(double focus_location, double focus_width, double zoom_factor) {
        double low_width_zoom;
        double[] boundaries = new double[4];
        double x1w = focus_location - focus_width / 2.0;
        double x2w = focus_location + focus_width / 2.0;
        double low_width_percentage_world = x1w / (1.0 - focus_width);
        double focus_width_zoom = focus_width * zoom_factor;
        double x1z = low_width_zoom = low_width_percentage_world * (1.0 - focus_width_zoom);
        double x2z = low_width_zoom + focus_width_zoom;
        boundaries[0] = x1w;
        boundaries[1] = x2w;
        boundaries[2] = x1z;
        boundaries[3] = x2z;
        return boundaries;
    }

    public double getFocusXworld() {
        return this.focusXworld;
    }

    public double getFocusYworld() {
        return this.focusYworld;
    }

    public double getFocusWidthWorld() {
        return this.focusWidthWorld;
    }

    public double getFocusHeightWorld() {
        return this.focusHeightWorld;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    @Override
    public void addZoomListener(ZoomListener listener) {
    }

    @Override
    public void removeZoomListener(ZoomListener listener) {
    }

    public String toString() {
        return "CartesianFisheyeZoom (xw, yw, ww, hw, zf): " + this.focusXworld + ", " + this.focusYworld + ", " + this.focusWidthWorld + ", " + this.focusHeightWorld + ", " + this.zoomFactor;
    }
}

