/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.graphic;

import com.macrofocus.color.ColorModel;
import com.macrofocus.color.ColormapModel;
import com.macrofocus.color.SimpleColormapModel;
import com.macrofocus.graphic.AbstractDirectGraphicModel;
import com.macrofocus.helper.ColorHelper;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public final class AlphaGraphicModel
extends AbstractDirectGraphicModel {
    private final int height;
    private final int width;
    private final int[] intBuffer;
    private final int[] alphaBuffer;
    private final ColormapModel colormapModel;
    private final MemoryImageSource memoryImageSource;
    private final Image memoryImage;
    private final java.awt.image.ColorModel cm;
    private final int alphaThreshold;

    public AlphaGraphicModel(Component component, int[] r, int[] g, int[] b, int[] a, int width, int height) {
        this(component, (ColormapModel)new SimpleColormapModel(r, g, b, a), width, height);
    }

    public AlphaGraphicModel(Component component, ColormapModel colormapModel, int width, int height) {
        this(component, colormapModel, 0, width, height);
    }

    public AlphaGraphicModel(Component component, ColormapModel colormapModel, int alphaThreshold, int width, int height) {
        this.width = width;
        this.height = height;
        this.alphaThreshold = alphaThreshold;
        this.colormapModel = colormapModel;
        this.intBuffer = new int[width * height];
        this.alphaBuffer = new int[width * height];
        for (int i = 0; i < this.alphaBuffer.length; ++i) {
            this.alphaBuffer[i] = 0;
        }
        this.cm = java.awt.image.ColorModel.getRGBdefault();
        this.memoryImageSource = new MemoryImageSource(width, height, this.cm, this.intBuffer, 0, width);
        this.memoryImageSource.setAnimated(true);
        this.memoryImage = component.createImage(this.memoryImageSource);
    }

    @Override
    public void drawPoint(int x, int y, ColorModel color) {
        if (x < 0) {
            return;
        }
        if (x >= this.width - 1) {
            return;
        }
        if (y < 0) {
            return;
        }
        if (y >= this.height - 1) {
            return;
        }
        int as = color.getAlpha();
        int rs = color.getRed();
        int gs = color.getGreen();
        int bs = color.getBlue();
        int d = this.intBuffer[(this.height - 1 - y) * this.width + x];
        int ad = this.alphaBuffer[(this.height - 1 - y) * this.width + x];
        int rd = d >> 16 & 0xFF;
        int gd = d >> 8 & 0xFF;
        int bd = d & 0xFF;
        int alpha = ColorHelper.intPrelerp((int)ad, (int)as, (int)as);
        this.intBuffer[(this.height - 1 - y) * this.width + x] = (alpha >= this.alphaThreshold ? 255 : 0) << 24 | ColorHelper.intPrelerp((int)rd, (int)rs, (int)as) << 16 | ColorHelper.intPrelerp((int)gd, (int)gs, (int)as) << 8 | ColorHelper.intPrelerp((int)bd, (int)bs, (int)as);
        this.alphaBuffer[(this.height - 1 - y) * this.width + x] = alpha;
    }

    public void drawPoint2(int x, int y, int color) {
        if (x < 0) {
            return;
        }
        if (x >= this.width - 1) {
            return;
        }
        if (y < 0) {
            return;
        }
        if (y >= this.height - 1) {
            return;
        }
        int d = this.intBuffer[(this.height - 1 - y) * this.width + x];
        int s = this.colormapModel.getColorModel(color).getRGBA();
        int as = this.cm.getAlpha(s);
        int rs = ColorHelper.intMult((int)as, (int)this.cm.getRed(s));
        int gs = ColorHelper.intMult((int)as, (int)this.cm.getGreen(s));
        int bs = ColorHelper.intMult((int)as, (int)this.cm.getBlue(s));
        int rd = this.cm.getRed(d);
        int gd = this.cm.getGreen(d);
        int bd = this.cm.getBlue(d);
        int ad = this.alphaBuffer[(this.height - 1 - y) * this.width + x];
        int alpha = (255 - this.cm.getAlpha(s)) * ad + this.cm.getAlpha(s);
        int red = rd + rs - ColorHelper.intMult((int)as, (int)rd);
        int green = gd + gs - ColorHelper.intMult((int)as, (int)gd);
        int blue = bd + bs - ColorHelper.intMult((int)as, (int)bd);
        int rp = red;
        int gp = green;
        int bp = blue;
        this.intBuffer[(this.height - 1 - y) * this.width + x] = bp | gp << 8 | rp << 16 | 0xFF000000;
        this.alphaBuffer[(this.height - 1 - y) * this.width + x] = alpha;
    }

    @Override
    public void drawBitmap(byte[] bit_map, int bit_map_width, int bit_map_height, int x, int y) {
        for (int i = 0; i < bit_map_height; ++i) {
            System.arraycopy(bit_map, i * bit_map_width, this.intBuffer, (this.height - 1 - (y + i)) * this.width + x, bit_map_width);
        }
    }

    @Override
    public void clearImage(int color) {
        this.clearImage(this.colormapModel.getColorModel(color));
    }

    @Override
    public void clearImage(ColorModel color) {
        int size = this.intBuffer.length - 1;
        int index = 1;
        this.intBuffer[0] = (color.getAlpha() >= this.alphaThreshold ? 255 : 0) << 24 | color.getRGB() & 0xFFFFFF;
        for (int cleared = 1; cleared < size; cleared <<= 1) {
            System.arraycopy(this.intBuffer, 0, this.intBuffer, index, cleared);
            size -= cleared;
            index += cleared;
        }
        System.arraycopy(this.intBuffer, 0, this.intBuffer, index, size);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public int getRed(int x, int y) {
        return this.cm.getRed(this.intBuffer[(this.height - 1 - y) * this.width + x]);
    }

    public int getGreen(int x, int y) {
        return this.cm.getGreen(this.intBuffer[(this.height - 1 - y) * this.width + x]);
    }

    public int getBlue(int x, int y) {
        return this.cm.getBlue(this.intBuffer[(this.height - 1 - y) * this.width + x]);
    }

    public int getAlpha(int x, int y) {
        return this.alphaBuffer[(this.height - 1 - y) * this.width + x];
    }

    @Override
    public ColormapModel getColormapModel() {
        return this.colormapModel;
    }

    @Override
    public Image getImage() {
        return this.memoryImage;
    }

    @Override
    public void newPixels() {
        this.memoryImageSource.newPixels();
    }

    @Override
    public void dispose() {
        this.memoryImage.flush();
    }
}

