/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.plot.guide;

import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.format.CPFormat;
import com.macrofocus.format.FormatFactory;
import com.macrofocus.format.swing.SwingFormatFactory;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPFontFactory;
import com.macrofocus.igraphics.IGraphics;
import com.macrofocus.igraphics.IHeadless;
import com.macrofocus.igraphics.swing.SwingColor;
import com.macrofocus.igraphics.swing.SwingIHeadless;
import com.macrofocus.plot.AxisPlotPanel;
import com.macrofocus.plot.guide.AbstractSwingGuide;
import com.macrofocus.plot.guide.AxisSpace;
import com.macrofocus.plot.guide.NumberAxis;
import com.macrofocus.plot.guide.NumberTick;
import com.macrofocus.plot.guide.RectangleEdge;
import com.macrofocus.plot.guide.ValueAxis;
import com.macrofocus.soom.lens.coordinate.CoordinateAxisEvent;
import com.macrofocus.soom.lens.coordinate.CoordinateAxisListener;
import com.macrofocus.soom.lens.coordinate.CoordinateAxisModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class XNumberCoordinateAxisGuide
extends AbstractSwingGuide {
    private final CPColor labelColor = new SwingColor(Color.black);
    private final CPColor gridLinesColor = new SwingColor(199, 199, 196);
    private final CPColor frameColor = new SwingColor(215, 215, 211);
    private final CoordinateAxisListener coordinateAxisListener = new CoordinateAxisListener(){

        @Override
        public void rangeChanged(CoordinateAxisEvent e) {
            XNumberCoordinateAxisGuide.this.repaint();
            XNumberCoordinateAxisGuide.this.invalidate();
            if (XNumberCoordinateAxisGuide.this.panel != null) {
                XNumberCoordinateAxisGuide.this.panel.valideAxis();
            }
        }
    };
    private CoordinateAxisModel coordinateAxis;
    private ValueAxis axis;
    private CPFormat format;
    private AxisPlotPanel panel;

    public XNumberCoordinateAxisGuide(CoordinateAxisModel coordinateAxis) {
        this();
        this.setCoordinateAxis(coordinateAxis);
    }

    private void setCoordinateAxis(CoordinateAxisModel coordinateAxis) {
        if (this.coordinateAxis != null) {
            this.coordinateAxis.removeCoordinateListener(this.coordinateAxisListener);
        }
        this.coordinateAxis = coordinateAxis;
        if (this.coordinateAxis != null) {
            this.coordinateAxis.addCoordinateListener(this.coordinateAxisListener);
        }
        this.invalidate();
        this.validateParent();
    }

    private XNumberCoordinateAxisGuide() {
    }

    public void setPanel(AxisPlotPanel panel) {
        this.panel = panel;
    }

    public double computeSpace(IGraphics g2, Rectangle dataArea) {
        AxisSpace space = new AxisSpace();
        this.getAxis().reserveSpace(g2, (Rectangle2D)dataArea, RectangleEdge.Bottom, space);
        return space.getBottom() + 4.0;
    }

    public void setFormat(CPFormat format) {
        this.format = format;
        if (this.axis != null) {
            this.axis.setFormatOverride(this.format);
        }
        this.repaint();
    }

    public void drawGrid(IGraphics g2, Dimension d) {
        double max;
        double min;
        if (this.coordinateAxis != null && (min = this.coordinateAxis.getWorldMin()) <= (max = this.coordinateAxis.getWorldMax())) {
            Rectangle2D.Float dataArea = new Rectangle2D.Float(0.0f, 0.0f, d.width, d.height);
            this.getAxis().setRange(min, max);
            List ticks = this.getAxis().refreshTicks(g2, (Rectangle2D)dataArea, RectangleEdge.Bottom);
            for (Object tick : ticks) {
                NumberTick t = (NumberTick)tick;
                int x = this.coordinateAxis.worldToScreen(t.getValue());
                g2.drawLine(x, 0, x, d.height);
            }
        }
    }

    public void paintComponent(IGraphics g2) {
        double max;
        double min;
        Dimension d = this.getSize();
        if (this.coordinateAxis != null && (min = Math.min(this.coordinateAxis.getWorldMin(), this.coordinateAxis.getWorldMax())) <= (max = Math.max(this.coordinateAxis.getWorldMin(), this.coordinateAxis.getWorldMax()))) {
            Rectangle2D.Float dataArea = new Rectangle2D.Float(0.0f, 0.0f, d.width, d.height);
            this.getAxis().setRange(min, max);
            List ticks = this.getAxis().refreshTicks(g2, (Rectangle2D)dataArea, RectangleEdge.Bottom);
            for (Object tick : ticks) {
                NumberTick t = (NumberTick)tick;
                int x = this.coordinateAxis.worldToScreen(t.getValue());
                g2.setColor(this.gridLinesColor);
                g2.drawLine(x, 0, x, 5);
                g2.setColor(this.labelColor);
                String text = t.getText();
                float width = g2.getStringWidth(text);
                g2.drawString(text, (float)x - width / 2.0f, (float)(d.height - 2));
            }
        }
        boolean drawFrame = false;
    }

    private ValueAxis getAxis() {
        if (this.axis == null) {
            this.axis = new NumberAxis((CPFontFactory)SwingFactory.getInstance(), (IHeadless)new SwingIHeadless(), (FormatFactory)SwingFormatFactory.getInstance());
            this.axis.setTickLabelFont(SwingFactory.getInstance().createFont("Tahoma", 0, 10));
            if (this.format != null) {
                this.axis.setFormatOverride(this.format);
            }
        }
        return this.axis;
    }

    public void setAxis(ValueAxis axis) {
        this.axis = axis;
        this.repaint();
    }
}

