/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.slider.controller;

import com.macrofocus.helper.SwingHelper;
import com.macrofocus.slider.adapter.MBoundedRangeSpinnerAdapter;
import com.macrofocus.slider.range.MRangeSlider;
import com.macrofocus.slider.single.MSingleSlider;
import com.macrofocus.slider.swing.JRangeSlider;
import com.macrofocus.util.range.MBoundedRangeModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import javax.swing.JFormattedTextField;
import javax.swing.JLayeredPane;
import javax.swing.JSpinner;
import javax.swing.Timer;
import javax.swing.text.NumberFormatter;

public class NumericInputController {
    private JLayeredPane layeredPane;
    private final Component c;
    private JSpinner valueSpinner;
    private JSpinner extendSpinner;
    private final MBoundedRangeSpinnerAdapter valueSpinnerAdapter;
    private final MBoundedRangeSpinnerAdapter extendSpinnerAdapter;
    private boolean valueVisible = true;
    private boolean extendVisible = false;
    private Position valuePosition = Position.HORIZONTAL_BOTTOM_LEFT;
    private Position extendPosition = Position.HORIZONTAL_BOTTOM_RIGHT;
    private NumberFormat format;
    private final Timer timer = new Timer(200, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!(NumericInputController.this.c.getMousePosition() != null || NumericInputController.this.valueSpinner != null && NumericInputController.this.valueSpinner.getMousePosition() != null || NumericInputController.this.extendSpinner != null && NumericInputController.this.extendSpinner.getMousePosition() != null)) {
                NumericInputController.this.removeSpinners();
            }
        }
    });

    public NumericInputController(JSpinner c, MBoundedRangeModel rangeModel) {
        this((Component)c, rangeModel);
        this.valuePosition = Position.HORIZONTAL_BOTTOM_LEFT;
        this.extendVisible = false;
    }

    public NumericInputController(MSingleSlider c, MBoundedRangeModel rangeModel) {
        this((Component)c, rangeModel);
        this.valuePosition = Position.VERTICAL_BOTTOM_LEFT;
        this.extendVisible = false;
    }

    public NumericInputController(JRangeSlider c, MBoundedRangeModel rangeModel) {
        this((Component)c, rangeModel);
        this.extendVisible = true;
        if (c.getOrientation() == 1) {
            this.valuePosition = Position.VERTICAL_BOTTOM_LEFT;
            this.extendPosition = Position.VERTICAL_TOP_LEFT;
        } else {
            this.valuePosition = Position.HORIZONTAL_BOTTOM_LEFT;
            this.extendPosition = Position.HORIZONTAL_BOTTOM_RIGHT;
        }
    }

    public NumericInputController(MRangeSlider c, MBoundedRangeModel rangeModel) {
        this((Component)c, rangeModel);
        this.extendVisible = true;
        this.valuePosition = Position.HORIZONTAL_BOTTOM_LEFT;
        this.extendPosition = Position.HORIZONTAL_BOTTOM_RIGHT;
    }

    public NumericInputController(Component c, MBoundedRangeModel rangeModel) {
        this.c = c;
        this.timer.setRepeats(false);
        this.valueSpinnerAdapter = new MBoundedRangeSpinnerAdapter(rangeModel);
        this.extendSpinnerAdapter = new MBoundedRangeSpinnerAdapter(rangeModel);
        this.extendSpinnerAdapter.setType(MBoundedRangeSpinnerAdapter.Type.EndValue);
        this.registerMouseListeners();
    }

    private JSpinner getValueSpinner() {
        if (this.valueSpinner == null) {
            this.valueSpinner = new JSpinner(this.valueSpinnerAdapter);
            this.valueSpinner.setOpaque(false);
            this.configureSpinner(this.valueSpinner);
            this.valueSpinner.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    NumericInputController.this.timer.stop();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    NumericInputController.this.timer.restart();
                }
            });
        }
        return this.valueSpinner;
    }

    private JSpinner getExtendSpinner() {
        if (this.extendSpinner == null) {
            this.extendSpinner = new JSpinner(this.extendSpinnerAdapter);
            this.extendSpinner.setOpaque(false);
            this.configureSpinner(this.extendSpinner);
            this.extendSpinner.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    NumericInputController.this.timer.stop();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    NumericInputController.this.timer.restart();
                }
            });
        }
        return this.extendSpinner;
    }

    public void setStepSize(Number size) {
        this.valueSpinnerAdapter.setStepSize(size);
        this.extendSpinnerAdapter.setStepSize(size);
    }

    public void setFormat(NumberFormat format) {
        this.format = format;
        if (this.valueSpinner != null) {
            this.configureSpinner(this.valueSpinner);
        }
        if (this.extendSpinner != null) {
            this.configureSpinner(this.extendSpinner);
        }
    }

    private void configureSpinner(JSpinner spinner) {
        if (this.format != null) {
            final NumberFormatter formatter = new NumberFormatter(this.format);
            JSpinner.DefaultEditor valueEditor = new JSpinner.DefaultEditor(spinner);
            JFormattedTextField.AbstractFormatterFactory factory = new JFormattedTextField.AbstractFormatterFactory(){

                @Override
                public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
                    return formatter;
                }
            };
            valueEditor.getTextField().setFormatterFactory(factory);
            valueEditor.getTextField().setColumns(7);
            valueEditor.getTextField().setEditable(true);
            spinner.setEditor(valueEditor);
        } else {
            JSpinner.NumberEditor valueEditor = new JSpinner.NumberEditor(spinner);
            valueEditor.getTextField().setColumns(7);
            spinner.setEditor(valueEditor);
        }
    }

    public void setValuePosition(Position valuePosition) {
        this.valuePosition = valuePosition;
    }

    public void setExtendPosition(Position extendPosition) {
        this.extendPosition = extendPosition;
    }

    public void setValueVisible(boolean valueVisible) {
        this.valueVisible = valueVisible;
    }

    public void setExtendVisible(boolean extendVisible) {
        this.extendVisible = extendVisible;
    }

    private void registerMouseListeners() {
        this.c.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                NumericInputController.this.timer.stop();
                NumericInputController.this.show(NumericInputController.this.getValueSpinner(), NumericInputController.this.valuePosition, NumericInputController.this.valueVisible);
                NumericInputController.this.show(NumericInputController.this.getExtendSpinner(), NumericInputController.this.extendPosition, NumericInputController.this.extendVisible);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                NumericInputController.this.timer.restart();
            }
        });
        this.c.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                NumericInputController.this.timer.restart();
            }
        });
    }

    private void removeSpinners() {
        if (this.valueSpinner != null) {
            this.layeredPane.remove(this.valueSpinner);
        }
        if (this.extendSpinner != null) {
            this.layeredPane.remove(this.extendSpinner);
        }
        this.layeredPane.validate();
        this.layeredPane.repaint();
    }

    private void show(JSpinner spinner, Position position, boolean visible) {
        this.layeredPane = SwingHelper.getTopLayeredPane((Component)this.c);
        this.layeredPane.add(spinner, JLayeredPane.POPUP_LAYER, 0);
        if (visible) {
            Point scrnLoc = this.c.getLocationOnScreen();
            Dimension d = spinner.getPreferredSize();
            int x = scrnLoc.x;
            int y = scrnLoc.y;
            switch (position.getVerticalPosition().ordinal()) {
                case 0: {
                    break;
                }
                case 1: {
                    y += this.c.getHeight();
                }
            }
            switch (position.getVerticalAlignment().ordinal()) {
                case 0: {
                    y -= d.height;
                    break;
                }
            }
            switch (position.getHorizontalPosition().ordinal()) {
                case 0: {
                    x += 0;
                    break;
                }
                case 2: {
                    x += this.c.getWidth();
                }
            }
            switch (position.getHorizontalAlignment().ordinal()) {
                case 0: {
                    x -= d.width;
                    break;
                }
                case 2: {
                    x += 0;
                }
            }
            Point p = SwingHelper.convertScreenLocationToParent((Container)spinner.getParent(), (int)x, (int)y);
            spinner.setLocation(p);
            spinner.setSize(d);
            this.layeredPane.validate();
        } else {
            spinner.setVisible(false);
        }
    }

    public void setBoundedRangeModel(MBoundedRangeModel rangeModel) {
        this.valueSpinnerAdapter.setBoundedRangeModel(rangeModel);
        this.extendSpinnerAdapter.setBoundedRangeModel(rangeModel);
    }

    public static class Position {
        private VerticalPlacement verticalPosition = VerticalPlacement.BOTTOM;
        private HorizontalPlacement horizontalPosition = HorizontalPlacement.RIGHT;
        private VerticalPlacement verticalAlignment = VerticalPlacement.BOTTOM;
        private HorizontalPlacement horizontalAlignment = HorizontalPlacement.RIGHT;
        public static Position HORIZONTAL_BOTTOM_LEFT = new Position(HorizontalPlacement.LEFT, HorizontalPlacement.RIGHT, VerticalPlacement.BOTTOM, VerticalPlacement.BOTTOM);
        public static Position HORIZONTAL_BOTTOM_RIGHT = new Position(HorizontalPlacement.RIGHT, HorizontalPlacement.LEFT, VerticalPlacement.BOTTOM, VerticalPlacement.BOTTOM);
        public static Position VERTICAL_TOP_LEFT = new Position(HorizontalPlacement.LEFT, HorizontalPlacement.LEFT, VerticalPlacement.TOP, VerticalPlacement.BOTTOM);
        public static Position VERTICAL_BOTTOM_LEFT = new Position(HorizontalPlacement.LEFT, HorizontalPlacement.LEFT, VerticalPlacement.BOTTOM, VerticalPlacement.TOP);

        private Position(HorizontalPlacement horizontalPosition, HorizontalPlacement horizontalAlignment, VerticalPlacement verticalPosition, VerticalPlacement verticalAlignment) {
            this.horizontalPosition = horizontalPosition;
            this.horizontalAlignment = horizontalAlignment;
            this.verticalPosition = verticalPosition;
            this.verticalAlignment = verticalAlignment;
        }

        public VerticalPlacement getVerticalPosition() {
            return this.verticalPosition;
        }

        public HorizontalPlacement getHorizontalPosition() {
            return this.horizontalPosition;
        }

        public VerticalPlacement getVerticalAlignment() {
            return this.verticalAlignment;
        }

        public HorizontalPlacement getHorizontalAlignment() {
            return this.horizontalAlignment;
        }
    }

    public static enum VerticalPlacement {
        TOP,
        BOTTOM;

    }

    public static enum HorizontalPlacement {
        LEFT,
        CENTER,
        RIGHT;

    }
}

