/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.soom.lens.coordinate;

import com.macrofocus.soom.lens.coordinate.CoordinateAxisEvent;
import com.macrofocus.soom.lens.coordinate.CoordinateAxisListener;
import com.macrofocus.soom.lens.coordinate.CoordinateAxisModel;
import com.macrofocus.soom.lens.zoom.ZoomStrategy;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class OptimizedCoordinateAxisModel
implements CoordinateAxisModel {
    private ZoomStrategy zoomStrategy = null;
    private boolean invertDeviceCoordinates = false;
    private boolean invertWorldCoordinates = false;
    private int screenSize;
    private double worldMin;
    private double worldMax;
    private double worldRange;
    private final List<CoordinateAxisListener> coordinateAxisListeners = new CopyOnWriteArrayList<CoordinateAxisListener>();

    private OptimizedCoordinateAxisModel() {
    }

    private OptimizedCoordinateAxisModel(int screenSize, double worldMin, double worldMax, double worldRange, ZoomStrategy zoomStrategy, boolean invertDeviceCoordinates, boolean invertWorldCoordinates) {
        this();
        this.screenSize = screenSize;
        this.worldMin = worldMin;
        this.worldMax = worldMax;
        this.worldRange = worldRange;
        this.zoomStrategy = zoomStrategy;
        this.invertDeviceCoordinates = invertDeviceCoordinates;
        this.invertWorldCoordinates = invertWorldCoordinates;
    }

    public OptimizedCoordinateAxisModel(int screenSize, double worldMin, double worldMax) {
        this();
        this.screenSize = screenSize;
        this.worldMax = worldMax;
        this.worldMin = worldMin;
        this.worldRange = worldMax - worldMin;
    }

    public OptimizedCoordinateAxisModel(double worldMin, double worldMax) {
        this(0, worldMin, worldMax);
    }

    @Override
    public void setDeviceCoordinatesInverted(boolean invertDeviceCoordinates) {
        this.invertDeviceCoordinates = invertDeviceCoordinates;
        this.fireRangeChanged(new CoordinateAxisEvent(this, this, CoordinateAxisEvent.Type.Screen));
    }

    @Override
    public void setWorldCoordinatesInverted(boolean invertWorldCoordinates) {
        this.invertWorldCoordinates = invertWorldCoordinates;
        this.fireRangeChanged(new CoordinateAxisEvent(this, this, CoordinateAxisEvent.Type.World));
    }

    @Override
    public boolean getDeviceCoordinatesInverted() {
        return this.invertDeviceCoordinates;
    }

    @Override
    public boolean getWorldCoordinatesInverted() {
        return this.invertWorldCoordinates;
    }

    @Override
    public void setZoomStrategy(ZoomStrategy zoomStrategy) {
        this.zoomStrategy = zoomStrategy;
        this.fireRangeChanged(new CoordinateAxisEvent(this, this, CoordinateAxisEvent.Type.Zoom));
    }

    @Override
    public ZoomStrategy getZoomStrategy() {
        return this.zoomStrategy;
    }

    @Override
    public int getScreenSize() {
        return this.screenSize;
    }

    @Override
    public double getWorldMin() {
        return this.worldMin;
    }

    @Override
    public double getWorldMax() {
        return this.worldMax;
    }

    @Override
    public double getWorldRange() {
        return this.worldRange;
    }

    @Override
    public void setScreenSize(int size) {
        if (this.screenSize != size) {
            this.screenSize = size;
            this.fireRangeChanged(new CoordinateAxisEvent(this, this, CoordinateAxisEvent.Type.Screen));
        }
    }

    @Override
    public void setWorld(double worldMinX, double worldMaxX) {
        if (this.worldMax != worldMaxX || this.worldMin != worldMinX) {
            this.worldMin = worldMinX;
            this.worldMax = worldMaxX;
            this.worldRange = this.worldMax - this.worldMin;
            this.fireRangeChanged(new CoordinateAxisEvent(this, this, CoordinateAxisEvent.Type.World));
        }
    }

    @Override
    public void setWorldMax(double worldMaxX) {
        if (this.worldMax != worldMaxX) {
            this.worldMax = worldMaxX;
            this.worldRange = this.worldMax - this.worldMin;
            this.fireRangeChanged(new CoordinateAxisEvent(this, this, CoordinateAxisEvent.Type.World));
        }
    }

    @Override
    public void setWorldMin(double worldMinX) {
        if (this.worldMin != worldMinX) {
            this.worldMin = worldMinX;
            this.worldRange = this.worldMax - this.worldMin;
            this.fireRangeChanged(new CoordinateAxisEvent(this, this, CoordinateAxisEvent.Type.World));
        }
    }

    @Override
    public final double screenToWorld(int x) {
        double xConverted = (double)x / (double)(this.screenSize - 1);
        if (this.invertDeviceCoordinates) {
            xConverted = 1.0 - xConverted;
        }
        if (this.zoomStrategy != null) {
            xConverted = this.zoomStrategy.zoomedToNormalized(xConverted);
        }
        if (this.invertWorldCoordinates) {
            xConverted = 1.0 - xConverted;
        }
        xConverted = xConverted * this.worldRange + this.worldMin;
        return xConverted;
    }

    @Override
    public final int worldToScreen(double x) {
        double xConverted = (x - this.worldMin) / this.worldRange;
        if (this.zoomStrategy != null) {
            xConverted = this.zoomStrategy.normalizedToZoomed(xConverted);
        }
        if (this.invertWorldCoordinates) {
            xConverted = 1.0 - xConverted;
        }
        if (this.invertDeviceCoordinates) {
            xConverted = 1.0 - xConverted;
        }
        return (int)(xConverted * (double)(this.screenSize - 1));
    }

    @Override
    public final double worldToNormalized(double x) {
        return (x - this.worldMin) / this.worldRange;
    }

    @Override
    public final double normalizedToWorld(double x) {
        return x * this.worldRange + this.worldMin;
    }

    @Override
    public final int normalizedToScreen(double xNormalized) {
        double xViewport = this.normalizedToViewport(xNormalized);
        return this.viewportToScreen(xViewport);
    }

    @Override
    public void setViewport(double min, double max) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setViewportMax(double viewportMaxX) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setViewportMin(double viewportMinX) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getViewportRange() {
        return 1.0;
    }

    @Override
    public double getViewportMin() {
        return 0.0;
    }

    @Override
    public double getViewportMax() {
        return 1.0;
    }

    @Override
    public double normalizedToViewport(double x_normalized) {
        x_normalized = (x_normalized - this.getViewportMin()) / this.getViewportRange();
        double x_zoomed = this.zoomStrategy != null ? this.zoomStrategy.normalizedToZoomed(x_normalized) : x_normalized;
        if (this.invertWorldCoordinates) {
            x_zoomed = 1.0 - x_zoomed;
        }
        return x_zoomed;
    }

    @Override
    public double viewportToNormalized(double viewport) {
        if (this.zoomStrategy != null) {
            viewport = this.zoomStrategy.zoomedToNormalized(viewport);
        }
        double normalized = viewport * this.getViewportRange() + this.getViewportMin();
        if (this.invertWorldCoordinates) {
            normalized = 1.0 - normalized;
        }
        return normalized;
    }

    @Override
    public int viewportToScreen(double x_viewport) {
        if (this.invertDeviceCoordinates) {
            x_viewport = 1.0 - x_viewport;
        }
        return (int)(x_viewport * (double)(this.getScreenSize() - 1));
    }

    @Override
    public double screenToViewport(int x_screen) {
        double x_viewport = (double)x_screen / (double)(this.getScreenSize() - 1);
        if (this.invertDeviceCoordinates) {
            x_viewport = 1.0 - x_viewport;
        }
        return x_viewport;
    }

    @Override
    public void addCoordinateListener(CoordinateAxisListener listener) {
        this.coordinateAxisListeners.add(listener);
    }

    @Override
    public void addWeakCoordinateListener(CoordinateAxisListener listener) {
        this.coordinateAxisListeners.add(new WeakCoordinateAxisListener(listener));
    }

    @Override
    public void removeCoordinateListener(CoordinateAxisListener listener) {
        this.coordinateAxisListeners.remove(listener);
    }

    void fireRangeChanged(CoordinateAxisEvent event) {
        for (CoordinateAxisListener coordinateAxisListener : this.coordinateAxisListeners) {
            coordinateAxisListener.rangeChanged(event);
        }
    }

    @Override
    public OptimizedCoordinateAxisModel copy() {
        return new OptimizedCoordinateAxisModel(this.screenSize, this.worldMin, this.worldMax, this.worldRange, this.getZoomStrategy(), this.getDeviceCoordinatesInverted(), this.getWorldCoordinatesInverted());
    }

    public String toString() {
        return this.getClass().getName() + " [screenSize=" + this.getScreenSize() + ", worldMin=" + this.getWorldMin() + ", worldMax=" + this.getWorldMax() + "]";
    }

    private class WeakCoordinateAxisListener
    implements CoordinateAxisListener {
        private final WeakReference<CoordinateAxisListener> l_ref;

        public WeakCoordinateAxisListener(CoordinateAxisListener listener) {
            this.l_ref = new WeakReference<CoordinateAxisListener>(listener);
        }

        @Override
        public void rangeChanged(CoordinateAxisEvent event) {
            CoordinateAxisListener l = (CoordinateAxisListener)this.l_ref.get();
            if (l != null) {
                l.rangeChanged(event);
            } else {
                OptimizedCoordinateAxisModel.this.removeCoordinateListener(this);
            }
        }
    }
}

