/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.awt;

import com.macrofocus.common.logging.Logging;
import java.awt.Component;

public class RepaintScheduler
extends Thread {
    private final Component component;
    private final int delay;
    private boolean isLocked;
    private boolean isAborted;
    private boolean isScheduled;
    private boolean isMutexed;
    private Object mutex;
    private Object lockMutex;
    private Object timerMutex;

    public RepaintScheduler(Component component, int delay) {
        this.component = component;
        this.delay = delay;
        this.isLocked = true;
        this.isScheduled = false;
        this.isAborted = false;
        this.isMutexed = false;
        this.mutex = new Object();
        this.lockMutex = new Object();
        this.timerMutex = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (Thread.currentThread() == this) {
            while (true) {
                this.lock();
                this.queueRepaint();
                try {
                    Object object = this.mutex;
                    synchronized (object) {
                        while (this.isMutexed) {
                            this.mutex.wait();
                        }
                    }
                    this.repaint();
                }
                catch (Exception e) {
                    Logging.getInstance().process((Throwable)e);
                }
            }
        }
    }

    public void scheduleRepaint() {
        if (this.isScheduled) {
            this.postponeRepaint();
        } else {
            this.unLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueRepaint() {
        try {
            Object object = this.timerMutex;
            synchronized (object) {
                this.isScheduled = true;
                while (this.isScheduled) {
                    this.timerMutex.wait(this.delay);
                    if (!this.isAborted) {
                        Object object2 = this.mutex;
                        synchronized (object2) {
                            this.isMutexed = false;
                            this.mutex.notifyAll();
                            this.isScheduled = false;
                            continue;
                        }
                    }
                    this.isAborted = false;
                }
            }
        }
        catch (Exception e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postponeRepaint() {
        Object object = this.timerMutex;
        synchronized (object) {
            this.isAborted = true;
            this.timerMutex.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lock() {
        Object object = this.lockMutex;
        synchronized (object) {
            while (this.isLocked) {
                try {
                    this.lockMutex.wait();
                }
                catch (Exception exception) {}
            }
            this.isLocked = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unLock() {
        Object object = this.lockMutex;
        synchronized (object) {
            this.isLocked = false;
            this.lockMutex.notifyAll();
        }
    }

    private void repaint() {
        this.component.repaint();
    }
}

