/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public class ImagePanel
extends JComponent
implements SwingConstants,
Printable {
    private Image image;
    private int verticalAlignment = 0;
    private int horizontalAlignment = 0;
    private Image scaledImage = null;

    public ImagePanel() {
    }

    public ImagePanel(Image image) {
        this.setImage(image);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.repaint();
    }

    public void setImage(String file) {
        this.setImage(new ImageIcon(file).getImage());
    }

    public void setImage(File file) {
        this.setImage(new ImageIcon(file.getAbsolutePath()).getImage());
    }

    public void setImage(byte[] imageData) {
        this.setImage(imageData == null ? null : new ImageIcon(imageData).getImage());
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int verticalAlignment) {
        if (verticalAlignment != 1 && verticalAlignment != 0 && verticalAlignment != 3) {
            throw new IllegalArgumentException("Invalid Vertical Alignment: " + verticalAlignment);
        }
        this.verticalAlignment = verticalAlignment;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        if (horizontalAlignment != 2 && horizontalAlignment != 0 && horizontalAlignment != 4) {
            throw new IllegalArgumentException("Invalid Horizontal Alignment: " + horizontalAlignment);
        }
        this.horizontalAlignment = horizontalAlignment;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.image == null) {
            return super.getPreferredSize();
        }
        return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        if (this.image == null) {
            return;
        }
        Insets insets = this.getInsets();
        int x = insets.left;
        int y = insets.top;
        int w = this.getWidth() - insets.left - insets.right;
        int h = this.getHeight() - insets.top - insets.bottom;
        int src_w = this.image.getWidth(null);
        int src_h = this.image.getHeight(null);
        double scale_x = (double)w / (double)src_w;
        double scale_y = (double)h / (double)src_h;
        double scale = Math.min(scale_x, scale_y);
        int dst_w = (int)Math.round(scale * (double)src_w);
        int dst_h = (int)Math.round(scale * (double)src_h);
        int dx = x + (w - dst_w) / 2;
        if (this.horizontalAlignment == 2) {
            dx = x;
        } else if (this.horizontalAlignment == 4) {
            dx = x + w - dst_w;
        }
        int dy = y + (h - dst_h) / 2;
        if (this.verticalAlignment == 1) {
            dy = y;
        } else if (this.verticalAlignment == 3) {
            dy = y + h - dst_h;
        }
        if (dst_w > 0 && dst_h > 0) {
            if (this.scaledImage == null || this.scaledImage.getWidth(null) != src_w || this.scaledImage.getHeight(null) != src_h) {
                this.scaledImage = this.image.getScaledInstance(dst_w, dst_h, 4);
            }
            g.drawImage(this.scaledImage, dx, dy, null);
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex > 0 || this.image == null) {
            return 1;
        }
        double w = pageFormat.getImageableWidth();
        double h = pageFormat.getImageableHeight();
        int src_w = this.image.getWidth(null);
        int src_h = this.image.getHeight(null);
        double scale_x = w / (double)src_w;
        double scale_y = h / (double)src_h;
        double scale = Math.min(scale_x, scale_y);
        int dst_w = (int)(scale * (double)src_w);
        int dst_h = (int)(scale * (double)src_h);
        int dx = (int)((w - (double)dst_w) / 2.0);
        int dy = (int)((h - (double)dst_h) / 2.0);
        graphics.drawImage(this.image, dx, dy, dx + dst_w, dy + dst_h, 0, 0, src_w, src_h, null);
        return 0;
    }

    public static BufferedImage getFasterScaledInstance(BufferedImage img, int targetWidth, int targetHeight, Object hint, boolean progressiveBilinear) {
        int h;
        int w;
        boolean isTranslucent;
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        BufferedImage scratchImage = null;
        Graphics2D g2 = null;
        int prevW = ret.getWidth();
        int prevH = ret.getHeight();
        boolean bl = isTranslucent = img.getTransparency() != 1;
        if (progressiveBilinear) {
            w = img.getWidth();
            h = img.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (progressiveBilinear && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (progressiveBilinear && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            if (scratchImage == null || isTranslucent) {
                scratchImage = new BufferedImage(w, h, type);
                g2 = scratchImage.createGraphics();
            }
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, 0, 0, prevW, prevH, null);
            prevW = w;
            prevH = h;
            ret = scratchImage;
        } while (w != targetWidth || h != targetHeight);
        if (g2 != null) {
            g2.dispose();
        }
        if (targetWidth != ret.getWidth() || targetHeight != ret.getHeight()) {
            scratchImage = new BufferedImage(targetWidth, targetHeight, type);
            g2 = scratchImage.createGraphics();
            g2.drawImage((Image)ret, 0, 0, null);
            g2.dispose();
            ret = scratchImage;
        }
        return ret;
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = ImagePanel.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }
}

