/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.Cacheable;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.table.JTableHeader;

public class TablePainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.TablePainter";

    protected TablePainter() {
    }

    public static TablePainter getInstance() {
        return TablePainter.getInstance(null);
    }

    public static TablePainter getInstance(SynthContext sc) {
        SyntheticaComponentPainter instance = (SyntheticaComponentPainter)instances.get(TablePainter.getPainterClassName(sc, TablePainter.class, UI_KEY));
        if (instance == null) {
            instance = TablePainter.getInstance(sc, TablePainter.class, UI_KEY);
        }
        return (TablePainter)instance;
    }

    public void paintTableBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintTableBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintTableHeaderBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JComponent c = sc.getComponent();
        String imagePath = this.resolveImagePath("Synthetica.tableHeader.background.image", c);
        if (imagePath != null && SyntheticaLookAndFeel.isOpaque(c)) {
            Insets sInsets;
            Insets dInsets = sInsets = this.getImageInsets("Synthetica.tableHeader.background.image.insets", c);
            ImagePainter iPainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
            iPainter.draw();
        }
    }

    public void paintTableHeaderBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintTableHeaderBackground(JTable table, SyntheticaState state, Graphics g, int x, int y, int w, int h) {
        JTableHeader header = table.getTableHeader();
        SynthStyle ss = SynthLookAndFeel.getStyleFactory().getStyle(header, Region.TABLE_HEADER);
        SynthContext sc = new SynthContext(header, Region.TABLE_HEADER, ss, state.getState());
        ss.getPainter(sc).paintTableHeaderBackground(sc, g, x, y, w, h);
    }

    public void paintTableHeaderCellBackground(JTable table, SyntheticaState state, Graphics g, int x, int y, int w, int h, int sortOrder) {
        JTableHeader header = table.getTableHeader();
        String imagePath = null;
        Insets insets = null;
        if (sortOrder == 1) {
            imagePath = this.resolveImagePath("Synthetica.tableHeader.ascendingSort.background.image", header);
            insets = this.getImageInsets("Synthetica.tableHeader.ascendingSort.background.image.insets", header);
        } else if (sortOrder == 2) {
            imagePath = this.resolveImagePath("Synthetica.tableHeader.descendingSort.background.image", header);
            insets = this.getImageInsets("Synthetica.tableHeader.descendingSort.background.image.insets", header);
        } else {
            imagePath = this.resolveImagePath("Synthetica.tableHeader.cell.background.image", header);
            insets = this.getImageInsets("Synthetica.tableHeader.cell.background.image.insets", header);
        }
        if (imagePath != null && SyntheticaLookAndFeel.isOpaque(header)) {
            ImagePainter iPainter = new ImagePainter(header, g, x, y, w, h, imagePath, insets, insets, 0, 0);
            iPainter.draw();
        }
    }

    @Override
    public Cacheable.ScaleType getCacheScaleType(String id) {
        if (!id.equals("paintTableHeaderBackground")) {
            return Cacheable.ScaleType.NINE_SQUARE;
        }
        return super.getCacheScaleType(id);
    }

    @Override
    public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
        if (!id.equals("paintTableHeaderBackground")) {
            return -1;
        }
        return super.getCacheHash(sc, w, h, meta, id);
    }
}

