/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.GraphicsUtils;
import de.javasoft.plaf.synthetica.Scalable;
import de.javasoft.plaf.synthetica.ScalableFont;
import de.javasoft.plaf.synthetica.ScalableIcon;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.SyntheticaPainter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.plaf.synth.SynthStyle;

public abstract class StyleWrapper
extends SynthStyle {
    private static Map<Icon, ScalableIcon.ScalableIconUIResource> iconCache = new HashMap<Icon, ScalableIcon.ScalableIconUIResource>();
    protected SynthStyle synthStyle;

    public StyleWrapper() {
    }

    public StyleWrapper(SynthStyle synthStyle) {
        this.synthStyle = synthStyle;
    }

    public static void reinitialize() {
        iconCache.clear();
    }

    void setStyle(SynthStyle style) {
        this.synthStyle = style;
    }

    public SynthStyle getStyle() {
        return this.synthStyle;
    }

    @Override
    public Object get(SynthContext sc, Object key) {
        return this.synthStyle.get(sc, key);
    }

    @Override
    public boolean getBoolean(SynthContext sc, Object key, boolean defaultValue) {
        return this.synthStyle.getBoolean(sc, key, defaultValue);
    }

    @Override
    public Color getColor(SynthContext sc, ColorType type) {
        return this.synthStyle.getColor(sc, type);
    }

    @Override
    public Color getColorForState(SynthContext sc, ColorType type) {
        return this.synthStyle.getColor(sc, type);
    }

    @Override
    public Font getFont(SynthContext sc) {
        Font font = this.synthStyle.getFont(sc);
        if (!this.isSyntheticaFontEnabled(sc) && font != null && !(font instanceof Scalable)) {
            font = new ScalableFont(font.deriveFont(font.getStyle(), SyntheticaLookAndFeel.getInstance().scaleFontSize(font.getSize())));
        }
        return font;
    }

    @Override
    public Font getFontForState(SynthContext sc) {
        return this.getFont(sc);
    }

    @Override
    public SynthGraphicsUtils getGraphicsUtils(SynthContext sc) {
        return this.synthStyle.getGraphicsUtils(sc);
    }

    @Override
    public Icon getIcon(SynthContext sc, Object key) {
        Icon icon = this.synthStyle.getIcon(sc, key);
        if (icon == null || icon instanceof Scalable || !SyntheticaLookAndFeel.getInstance().isUIScalingEnabled()) {
            return icon;
        }
        ScalableIcon.ScalableIconUIResource si = iconCache.get(icon);
        if (si == null) {
            Icon hiDpiIcon = this.synthStyle.getIcon(sc, key + SyntheticaLookAndFeel.getInstance().getScaleKeyExtension());
            si = hiDpiIcon == null ? new ScalableIcon.ScalableIconUIResource(icon) : new ScalableIcon.ScalableIconUIResource(GraphicsUtils.iconToImage(sc, icon), GraphicsUtils.iconToImage(sc, hiDpiIcon));
            iconCache.put(icon, si);
        }
        return si;
    }

    @Override
    public Insets getInsets(SynthContext sc, Insets insets) {
        Insets ins = this.synthStyle.getInsets(sc, insets);
        return ins == null ? null : SyntheticaLookAndFeel.getInstance().scaleInsets(ins);
    }

    @Override
    public int getInt(SynthContext sc, Object key, int defaultValue) {
        Object value = this.synthStyle.get(sc, key);
        if (value instanceof Number) {
            int val = ((Number)value).intValue();
            return val == 0 ? val : SyntheticaLookAndFeel.getInstance().scaleInteger(val);
        }
        return defaultValue;
    }

    @Override
    public SynthPainter getPainter(SynthContext sc) {
        return SyntheticaPainter.getInstance();
    }

    @Override
    public String getString(SynthContext sc, Object key, String defaultValue) {
        return this.synthStyle.getString(sc, key, defaultValue);
    }

    @Override
    public void installDefaults(SynthContext sc) {
        JComponent c;
        Font font;
        this.synthStyle.installDefaults(sc);
        if (!this.isSyntheticaFontEnabled(sc) && ((font = (c = sc.getComponent()).getFont()) == null || font instanceof UIResource)) {
            c.setFont(this.getFontForState(sc));
        }
    }

    @Override
    public boolean isOpaque(SynthContext sc) {
        return this.synthStyle.isOpaque(sc);
    }

    @Override
    public void uninstallDefaults(SynthContext sc) {
        this.synthStyle.uninstallDefaults(sc);
    }

    private boolean isSyntheticaFontEnabled(SynthContext sc) {
        return SyntheticaLookAndFeel.getBoolean("Synthetica.font.enabled", sc.getComponent(), true);
    }
}

