/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.util;

import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class ColorBurnComposite
implements Composite,
CompositeContext {
    public static final ColorBurnComposite ColorBurn = new ColorBurnComposite();

    @Override
    public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
        int width = Math.min(src.getWidth(), dstIn.getWidth());
        int height = Math.min(src.getHeight(), dstIn.getHeight());
        int[] srcPixels = new int[width];
        int[] dstPixels = new int[width];
        int y = 0;
        while (y < height) {
            src.getDataElements(0, y, width, 1, srcPixels);
            dstIn.getDataElements(0, y, width, 1, dstPixels);
            int x = 0;
            while (x < width) {
                dstPixels[x] = ColorBurnComposite.colorBurnRGB(srcPixels[x], dstPixels[x]);
                ++x;
            }
            dstOut.setDataElements(0, y, width, 1, dstPixels);
            ++y;
        }
    }

    static int colorBurnRGB(int rgb1, int rgb2) {
        int b1 = rgb2 & 0xFF;
        int b2 = rgb1 & 0xFF;
        int b = b1 == 0 ? 0 : Math.max(0, 255 - (255 - b2 << 8) / b1);
        int g1 = rgb2 >> 8 & 0xFF;
        int g2 = rgb1 >> 8 & 0xFF;
        int g = g1 == 0 ? 0 : Math.max(0, 255 - (255 - g2 << 8) / g1);
        int r1 = rgb2 >> 16 & 0xFF;
        int r2 = rgb1 >> 16 & 0xFF;
        int r = r1 == 0 ? 0 : Math.max(0, 255 - (255 - r2 << 8) / r1);
        int a1 = rgb2 >> 24 & 0xFF;
        int a2 = rgb1 >> 24 & 0xFF;
        int a = Math.min(255, a1 + a2 - a1 * a2 / 255);
        return b | g << 8 | r << 16 | a << 24;
    }

    @Override
    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        return this;
    }

    @Override
    public void dispose() {
    }
}

