/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.util;

import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class MultiplyComposite
implements Composite,
CompositeContext {
    public static final MultiplyComposite Multiply = new MultiplyComposite();

    @Override
    public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
        int width = Math.min(src.getWidth(), dstIn.getWidth());
        int height = Math.min(src.getHeight(), dstIn.getHeight());
        int[] srcPixels = new int[width];
        int[] dstPixels = new int[width];
        int y = 0;
        while (y < height) {
            src.getDataElements(0, y, width, 1, srcPixels);
            dstIn.getDataElements(0, y, width, 1, dstPixels);
            int x = 0;
            while (x < width) {
                dstPixels[x] = MultiplyComposite.multiplyRGB(srcPixels[x], dstPixels[x]);
                ++x;
            }
            dstOut.setDataElements(0, y, width, 1, dstPixels);
            ++y;
        }
    }

    static int multiplyRGB(int rgb1, int rgb2) {
        int b1 = rgb1 & 0xFF;
        int b2 = rgb2 & 0xFF;
        int b = b1 * b2 / 255;
        int g1 = rgb1 >> 8 & 0xFF;
        int g2 = rgb2 >> 8 & 0xFF;
        int g = g1 * g2 / 255;
        int r1 = rgb1 >> 16 & 0xFF;
        int r2 = rgb2 >> 16 & 0xFF;
        int r = r1 * r2 / 255;
        int a1 = rgb1 >> 24 & 0xFF;
        int a2 = rgb2 >> 24 & 0xFF;
        int a = Math.min(255, a1 + a2);
        return b | g << 8 | r << 16 | a << 24;
    }

    @Override
    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        return this;
    }

    @Override
    public void dispose() {
    }
}

