/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.util;

import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class OverlayComposite
implements Composite,
CompositeContext {
    public static final OverlayComposite Overlay = new OverlayComposite();

    @Override
    public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
        int width = Math.min(src.getWidth(), dstIn.getWidth());
        int height = Math.min(src.getHeight(), dstIn.getHeight());
        int[] srcPixels = new int[width];
        int[] dstPixels = new int[width];
        int y = 0;
        while (y < height) {
            src.getDataElements(0, y, width, 1, srcPixels);
            dstIn.getDataElements(0, y, width, 1, dstPixels);
            int x = 0;
            while (x < width) {
                dstPixels[x] = OverlayComposite.overlayRGB(srcPixels[x], dstPixels[x]);
                ++x;
            }
            dstOut.setDataElements(0, y, width, 1, dstPixels);
            ++y;
        }
    }

    static int overlayRGB(int rgb1, int rgb2) {
        int b1 = rgb2 & 0xFF;
        int b2 = rgb1 & 0xFF;
        int b = b2 < 128 ? b2 * b1 >> 7 : 255 - ((255 - b2) * (255 - b1) >> 7);
        int g1 = rgb2 >> 8 & 0xFF;
        int g2 = rgb1 >> 8 & 0xFF;
        int g = g2 < 128 ? g2 * g1 >> 7 : 255 - ((255 - g2) * (255 - g1) >> 7);
        int r1 = rgb2 >> 16 & 0xFF;
        int r2 = rgb1 >> 16 & 0xFF;
        int r = r2 < 128 ? r2 * r1 >> 7 : 255 - ((255 - r2) * (255 - r1) >> 7);
        int a1 = rgb2 >> 24 & 0xFF;
        int a2 = rgb1 >> 24 & 0xFF;
        int a = Math.min(255, a1 + a2 - a1 * a2 / 255);
        return b | g << 8 | r << 16 | a << 24;
    }

    @Override
    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        return this;
    }

    @Override
    public void dispose() {
    }
}

