/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.dataframe;

import com.macrofocus.common.collection.PluggableCollectionFactory;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.DataFrameEvent;
import com.macrofocus.molap.dataframe.ReMappedDataFrame;
import com.macrofocus.molap.dataframe.ReMappedRecipe;
import com.macrofocus.molap.index.DefaultUniqueIndex;
import com.macrofocus.molap.index.UniqueIndex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class WrappedDataFrame<R, C, V>
extends ReMappedDataFrame<R, C, V> {
    private List<C> a = new ArrayList<C>();
    private Map<C, Column<R, C, V>> b = new LinkedHashMap<C, Column<R, C, V>>();
    private final ColumnListener<R, C, V> c = new ColumnListener<R, C, V>(this){
        private /* synthetic */ WrappedDataFrame a;
        {
            this.a = wrappedDataFrame;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void columnChanged(ColumnEvent<R, C, V> event) {
            void var1_1;
            this.a.notifyDataFrameChanged(new DataFrameEvent(event.getAffectedRows(), Collections.singleton(var1_1.getAffectedColumn()), false));
        }
    };

    public WrappedDataFrame(DataFrame<R, C, V> dataFrame) {
        super(dataFrame, null);
        ReMappedRecipe reMappedRecipe;
        reMappedRecipe = new ReMappedRecipe<R, C>(){
            private /* synthetic */ DataFrame a;
            private /* synthetic */ WrappedDataFrame b;
            {
                this.b = wrappedDataFrame;
                this.a = dataFrame;
            }

            @Override
            public final UniqueIndex<R> buildRowIndex() {
                return this.a.getRowIndex();
            }

            @Override
            public final UniqueIndex<C> buildColumnIndex() {
                return new DefaultUniqueIndex(this.b.a, false);
            }
        };
        this.setRecipe(reMappedRecipe);
    }

    @Override
    public String getColumnName(C c2) {
        Column<R, C, V> column;
        if ((column = this.b.get(column)) != null) {
            return column.getColumnName();
        }
        return "";
    }

    @Override
    public Class getColumnClass(C c2) {
        Column<R, C, V> column;
        if ((column = this.b.get(column)) != null) {
            return column.getType(this);
        }
        return Object.class;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V getValueAt(R r2, C c2) {
        Column<void, C, V> column;
        if ((column = this.b.get(column)) != null) {
            void var1_1;
            return column.getValue(this, var1_1);
        }
        return null;
    }

    public void addOriginalColumns() {
        for (Object c2 : this.dataFrame.columns()) {
            assert (((ReMappedDataFrame)this).getOriginalDataFrame().getColumnIndex().contains(c2)) : "Column " + String.valueOf(c2) + " doesn't exists";
            assert (!this.b.containsKey(c2)) : "Column " + String.valueOf(c2) + " already exists";
            this.a.add(c2);
            this.b.put(c2, new InternalDataFrameColumn(this, c2));
        }
        this.invalidate();
        this.scheduleUpdate();
    }

    public void addOriginalColumn(C ... columns) {
        C[] CArray = columns;
        int n2 = columns.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            C c2 = CArray[i2];
            assert (((ReMappedDataFrame)this).getOriginalDataFrame().getColumnIndex().contains(c2)) : "Column " + String.valueOf(c2) + " doesn't exists";
            assert (!this.b.containsKey(c2)) : "Column " + String.valueOf(c2) + " already exists";
            this.a.add(c2);
            this.b.put(c2, new InternalDataFrameColumn(this, c2));
        }
        this.invalidate();
        this.scheduleUpdate();
    }

    /*
     * WARNING - void declaration
     */
    public void addRenamedColumn(C column, C name) {
        void var2_2;
        void var1_1;
        this.addRenamedColumn(var1_1, var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public void addRenamedColumn(C column, C name, boolean checkExists) {
        void var1_1;
        void var2_2;
        void var3_3;
        assert (var3_3 == false || ((ReMappedDataFrame)this).getOriginalDataFrame().getColumnIndex().contains(column)) : "Column " + String.valueOf(column) + " doesn't exists";
        assert (!this.b.containsKey(column)) : "Column " + String.valueOf(column) + " already exists";
        this.a.add(name);
        this.b.put(name, new InternalDataFrameColumn(this, var2_2, var1_1));
        this.invalidate();
        this.scheduleUpdate();
    }

    public void addDerivedColumn(Column<R, C, V> ... columns) {
        Column<R, C, V>[] columnArray = columns;
        int n2 = columns.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Column<R, C, V> column = columnArray[i2];
            this.a.add(column.getKey());
            this.b.put(column.getKey(), column);
            column.addColumnListener(this.c);
        }
        this.invalidate();
        this.scheduleUpdate();
    }

    public void removeDerivedColumn(Column<R, C, V> ... columns) {
        Column<R, C, V>[] columnArray = columns;
        int n2 = columns.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Column<R, C, V> column = columnArray[i2];
            this.a.remove(column.getKey());
            this.b.remove(column.getKey(), column);
            column.removeColumnListener(this.c);
        }
        this.invalidate();
        this.scheduleUpdate();
    }

    @Override
    public DataFrame<R, C, V> getOriginalDataFrame() {
        return this.dataFrame;
    }

    /*
     * WARNING - void declaration
     */
    public Column getCalculatedColumnAt(int i2) {
        void var1_1;
        return this.b.get(this.a.get((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void modifyColumn(C oldColumn, Column<R, C, V> column) {
        void var2_2;
        void var1_1;
        this.b.get(oldColumn).removeColumnListener(this.c);
        this.a.set(this.a.indexOf(oldColumn), column.getKey());
        this.b.put(var1_1, column);
        this.b.put(column.getKey(), column);
        var2_2.addColumnListener(this.c);
        this.invalidate();
        this.scheduleUpdate();
    }

    public static interface ColumnListener<R, C, V> {
        public void columnChanged(ColumnEvent<R, C, V> var1);
    }

    public static interface Column<R, C, V> {
        public C getKey();

        public Class getType(WrappedDataFrame<R, C, V> var1);

        public String getColumnName();

        public V getValue(WrappedDataFrame<R, C, V> var1, R var2);

        public void addColumnListener(ColumnListener<R, C, V> var1);

        public void removeColumnListener(ColumnListener<R, C, V> var1);
    }

    public class InternalDataFrameColumn
    implements Column<R, C, V> {
        private final C a;
        private final C b;
        private /* synthetic */ WrappedDataFrame c;

        /*
         * WARNING - void declaration
         */
        public InternalDataFrameColumn(WrappedDataFrame this$0, C column, C sourceColumn) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.c = var1_1;
            this.a = var2_2;
            this.b = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public InternalDataFrameColumn(WrappedDataFrame this$0, C column) {
            void var1_1;
            void var2_2;
            void v0 = var2_2;
            this((WrappedDataFrame)var1_1, v0, v0);
        }

        @Override
        public C getKey() {
            return this.a;
        }

        @Override
        public Class getType(WrappedDataFrame<R, C, V> dataFrame) {
            return ((ReMappedDataFrame)this.c).getOriginalDataFrame().getColumnClass(this.b);
        }

        @Override
        public String getColumnName() {
            return this.a.toString();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V getValue(WrappedDataFrame<R, C, V> dataFrame, R r2) {
            void var2_2;
            return ((ReMappedDataFrame)this.c).getOriginalDataFrame().getValueAt(var2_2, this.b);
        }

        @Override
        public void addColumnListener(ColumnListener<R, C, V> listener) {
        }

        @Override
        public void removeColumnListener(ColumnListener<R, C, V> listener) {
        }
    }

    public static class ColumnEvent<R, C, V> {
        private final Iterable<R> a;
        private final C b;

        /*
         * WARNING - void declaration
         */
        public ColumnEvent(Iterable<R> affectedRows, C affectedColumn) {
            void var2_2;
            void var1_1;
            this.a = var1_1;
            this.b = var2_2;
        }

        public Iterable<R> getAffectedRows() {
            return this.a;
        }

        public C getAffectedColumn() {
            return this.b;
        }
    }

    public static class DataFrameColumn<R, C, V>
    implements Column<R, C, V> {
        private final DataFrame<R, C, V> a;
        private final C b;
        private final C c;

        /*
         * WARNING - void declaration
         */
        public DataFrameColumn(DataFrame<R, C, V> dataFrame, C sourceColumn, C column) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.a = var1_1;
            this.c = var2_2;
            this.b = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public DataFrameColumn(DataFrame<R, C, V> dataFrame, C column) {
            void var1_1;
            void var2_2;
            void v0 = var2_2;
            this((DataFrame<R, void, V>)var1_1, v0, v0);
        }

        @Override
        public C getKey() {
            return this.b;
        }

        @Override
        public Class getType(WrappedDataFrame<R, C, V> dataFrame) {
            return this.a.getColumnClass(this.c);
        }

        @Override
        public String getColumnName() {
            return this.b.toString();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V getValue(WrappedDataFrame<R, C, V> dataFrame, R r2) {
            void var2_2;
            return this.a.getValueAt(var2_2, this.c);
        }

        @Override
        public void addColumnListener(ColumnListener<R, C, V> listener) {
        }

        @Override
        public void removeColumnListener(ColumnListener<R, C, V> listener) {
        }
    }

    public static class SumColumn<R, C, V>
    extends DerivedColumn<R, C, V> {
        private final C[] a;

        /*
         * WARNING - void declaration
         */
        public SumColumn(C column, C ... columns) {
            super(var1_1, Number.class);
            void var2_2;
            void var1_1;
            this.a = var2_2;
        }

        @Override
        public V getValue(WrappedDataFrame<R, C, V> dataFrame, R r2) {
            DataFrame dataFrame2;
            Number number = null;
            dataFrame2 = ((ReMappedDataFrame)dataFrame2).getOriginalDataFrame();
            C[] CArray = this.a;
            int n2 = this.a.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = CArray[i2];
                if ((object = dataFrame2.getValueAt(r2, object)) == null || !(object instanceof Number)) continue;
                object = (Number)object;
                number = number == null ? (Number)((Number)object) : (Number)(number.doubleValue() + ((Number)object).doubleValue());
            }
            return (V)number;
        }
    }

    public static abstract class DerivedColumn<R, C, V>
    implements Column<R, C, V> {
        private final C a;
        private final Class b;
        private List<ColumnListener<R, C, V>> c;

        /*
         * WARNING - void declaration
         */
        public DerivedColumn(C column, Class type) {
            void var2_2;
            void var1_1;
            this.a = var1_1;
            this.b = var2_2;
        }

        @Override
        public String getColumnName() {
            return this.getKey().toString();
        }

        @Override
        public C getKey() {
            return this.a;
        }

        @Override
        public Class getType(WrappedDataFrame<R, C, V> dataFrame) {
            return this.b;
        }

        public String toString() {
            return this.a.toString();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void addColumnListener(ColumnListener<R, C, V> listener) {
            void var1_1;
            if (this.c == null) {
                this.c = new ArrayList<ColumnListener<R, C, V>>();
            }
            this.c.add((ColumnListener<R, C, V>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void removeColumnListener(ColumnListener<R, C, V> listener) {
            void var1_1;
            this.c.remove(var1_1);
        }
    }

    public static abstract class NamedTypedColumn<R, V>
    extends AbstractColumn<R, String, V> {
        private String a;
        private Class b;

        /*
         * WARNING - void declaration
         */
        public NamedTypedColumn(String name, Class type) {
            void var2_2;
            void var1_1;
            this.a = var1_1;
            this.b = var2_2;
        }

        @Override
        public String getKey() {
            return this.getColumnName();
        }

        @Override
        public Class getType(WrappedDataFrame<R, String, V> dataFrame) {
            return this.b;
        }

        @Override
        public String getColumnName() {
            return this.a;
        }
    }

    public static abstract class AbstractColumn<R, C, V>
    implements Column<R, C, V> {
        private final List<ColumnListener<R, C, V>> a = PluggableCollectionFactory.getInstance().copyOnWriteArrayList();

        /*
         * WARNING - void declaration
         */
        @Override
        public void addColumnListener(ColumnListener<R, C, V> listener) {
            void var1_1;
            this.a.add((ColumnListener<R, C, V>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void removeColumnListener(ColumnListener<R, C, V> listener) {
            void var1_1;
            this.a.remove(var1_1);
        }

        protected void notifyColumnChanged(ColumnEvent<R, C, V> event) {
            for (ColumnListener<R, C, V> columnListener : this.a) {
                columnListener.columnChanged(event);
            }
        }
    }
}

