/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.table;

import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class NumberTableCellRenderer
implements TableCellRenderer {
    private TableCellRenderer delegate;
    private NumberFormat nf;

    public NumberTableCellRenderer(TableCellRenderer defaultRenderer, Class<?> dataClass, int minDigits, int maxDigits) {
        this.delegate = defaultRenderer;
        this.nf = NumberFormat.getInstance();
        if (dataClass == Float.class || dataClass == Double.class) {
            this.nf.setMinimumFractionDigits(minDigits);
            this.nf.setMaximumFractionDigits(maxDigits);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel l = (JLabel)this.delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value != null) {
            String s = this.nf.format(value);
            l.setText(s);
            l.setHorizontalAlignment(4);
        }
        return l;
    }
}

