/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.ui;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class SyntheticaComboBoxUI
extends BasicComboBoxUI {
    protected JComboBox<Object> delegate = new JComboBox();
    private BasicComboBoxUI ui = (BasicComboBoxUI)this.delegate.getUI();

    public static ComponentUI createUI(JComponent c) {
        return new SyntheticaComboBoxUI();
    }

    @Override
    public void installUI(JComponent c) {
        SyntheticaLookAndFeel.getStyleFactory().getStyle(c, Region.COMBO_BOX);
        super.installUI(c);
        Border border = c.getBorder();
        if (border == null || border instanceof DefaultListCellRenderer.UIResource) {
            c.setBorder(this.delegate.getBorder());
        }
    }

    @Override
    protected JButton createArrowButton() {
        JButton button = null;
        try {
            Method method = this.ui.getClass().getDeclaredMethod("createArrowButton", new Class[0]);
            method.setAccessible(true);
            button = (JButton)method.invoke((Object)this.ui, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return button;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Border border;
        Boolean arrowButtonEnabled;
        super.update(g, c);
        SynthStyle ss = SynthLookAndFeel.getStyle(this.delegate, Region.COMBO_BOX);
        this.delegate.setOpaque(c.isOpaque());
        this.delegate.putClientProperty("Synthetica.opaque", SyntheticaLookAndFeel.isOpaque((JComponent)c));
        if (this.delegate.isEnabled() != c.isEnabled()) {
            this.delegate.setEnabled(c.isEnabled());
        }
        if (this.delegate.isEditable() != ((JComboBox)c).isEditable()) {
            this.delegate.setEditable(((JComboBox)c).isEditable());
        }
        if ((arrowButtonEnabled = (Boolean)c.getClientProperty("ComboBox.arrowButton.enabled")) != null && arrowButtonEnabled.booleanValue() != this.arrowButton.isEnabled()) {
            this.arrowButton.setEnabled(c.isEnabled() & arrowButtonEnabled);
        }
        if ((border = c.getBorder()) == null || border instanceof DefaultListCellRenderer.UIResource) {
            c.setBorder(this.delegate.getBorder());
        }
        if (((JComboBox)c).isEditable()) {
            ((JComponent)this.editor).setOpaque(c.isOpaque());
            ((JComponent)this.editor).putClientProperty("Synthetica.opaque", c.getClientProperty("Synthetica.opaque"));
            ((JComponent)this.editor).setBorder(((JComponent)this.delegate.getEditor().getEditorComponent()).getBorder());
        }
        int state = 0;
        if (c.isEnabled()) {
            state |= 1;
        } else if (!c.isEnabled()) {
            state |= 8;
        }
        if (c.hasFocus()) {
            state |= 0x100;
        }
        SynthContext sc = new SynthContext(c, Region.COMBO_BOX, ss, state);
        if (SyntheticaLookAndFeel.isOpaque((JComponent)c)) {
            ss.getPainter(sc).paintComboBoxBackground(sc, g, 0, 0, c.getWidth(), c.getHeight());
            this.paint(g, c);
        }
    }

    @Override
    protected ListCellRenderer<Object> createRenderer() {
        return this.delegate.getRenderer();
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        Font font = c.getFont();
        if (this.delegate.getFont() != font) {
            this.delegate.setFont(font);
        }
        return this.delegate.getBaseline(width, height);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable()) {
            if (c.getForeground() instanceof ColorUIResource) {
                c.setForeground(this.listBox.getForeground());
            }
            Rectangle r = this.rectangleForCurrentValue();
            this.paintCurrentValue(g, r, this.hasFocus);
        }
    }
}

