/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.io.IOException;
import java.util.List;
import org.opendatafoundation.data.spss.SPSSAbstractRecordType;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;

public class SPSSRecordType7Subtype5
extends SPSSAbstractRecordType {
    int recordTypeCode;
    int recordSubtypeCode;
    int dataElementLength;
    int numberOfDataElements;
    String variableSets;
    List<byte[]> dataElement;

    @Override
    public void read(SPSSFile sPSSFile) throws IOException, SPSSFileException {
        this.fileLocation = sPSSFile.getFilePointer();
        this.recordTypeCode = sPSSFile.readSPSSInt();
        if (this.recordTypeCode != 7) {
            throw new SPSSFileException("Error reading record type 7 subtype 5: bad record type [" + this.recordTypeCode + "]. Expecting Record Type 7.");
        }
        this.recordSubtypeCode = sPSSFile.readSPSSInt();
        if (this.recordSubtypeCode != 5) {
            throw new SPSSFileException("Error reading record type 7 subtype 5: bad subrecord type [" + this.recordSubtypeCode + "]. Expecting Record Subtype 5.");
        }
        this.dataElementLength = sPSSFile.readSPSSInt();
        if (this.dataElementLength != 1) {
            throw new SPSSFileException("Error reading record type 7 subtype 3: bad data element length [" + this.dataElementLength + "]. Expecting 1.");
        }
        this.numberOfDataElements = sPSSFile.readSPSSInt();
        this.variableSets = sPSSFile.readSPSSString(this.numberOfDataElements);
    }

    @Override
    public String toString() {
        String string = "";
        string = string + "\nRECORD TYPE 7 SUBTYPE 5 - VARIABLE SETS INFORMATION";
        string = string + "\nLocation        : " + this.fileLocation;
        string = string + "\nRecord Type     : " + this.recordTypeCode;
        string = string + "\nRecord Subtype  : " + this.recordSubtypeCode;
        string = string + "\nData elements   : " + this.numberOfDataElements;
        string = string + "\nElement length  : " + this.dataElementLength;
        string = string + "\nVariable sets   :\n " + this.variableSets;
        return string;
    }
}

