/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.originalfastvoronoi.convexHull;

import com.treemap.swing.originalfastvoronoi.convexHull.HEdge;
import com.treemap.swing.originalfastvoronoi.convexHull.JConflictList;
import com.treemap.swing.originalfastvoronoi.convexHull.JFace;
import com.treemap.swing.originalfastvoronoi.convexHull.JGraphEdge;
import com.treemap.swing.originalfastvoronoi.convexHull.JVertex;
import com.treemap.swing.originalfastvoronoi.convexHull.NotEnoughPointsException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class JConvexHull {
    private List<JVertex> points;
    private List<JFace> facets;
    private List<JFace> created;
    private List<HEdge> horizon;
    private List<JFace> visible;
    private int current = 0;
    private boolean permutate = false;
    protected final Random rand = new Random(1985L);

    public JConvexHull() {
        this.points = new ArrayList<JVertex>();
        this.facets = new ArrayList<JFace>();
        this.created = new ArrayList<JFace>();
        this.horizon = new ArrayList<HEdge>();
        this.visible = new ArrayList<JFace>();
    }

    public void addPoint(JVertex v) {
        JVertex tempVertex = new JVertex(v.x, v.y, v.z);
        tempVertex.originalObject = v;
        tempVertex.setIndex(this.points.size());
        this.points.add(tempVertex);
    }

    public void addPoint(double x, double y, double z) {
        JVertex v = new JVertex(x, y, z);
        v.setIndex(this.points.size());
        this.points.add(v);
    }

    public List<JFace> compute() {
        this.prep();
        while (this.current < this.points.size()) {
            JVertex next = this.points.get(this.current);
            if (next.getList().empty()) {
                ++this.current;
                continue;
            }
            this.created.clear();
            this.horizon.clear();
            this.visible.clear();
            next.getList().fill(this.visible);
            for (JFace jF : this.visible) {
                HEdge e = jF.getHorizon();
                if (e == null) continue;
                e.findHorizon(this.horizon);
                break;
            }
            JFace last = null;
            JFace first = null;
            for (HEdge hE : this.horizon) {
                JFace fn = new JFace(next, hE.getOrigin(), hE.getDest(), hE.getTwin().getNext().getDest());
                fn.setList(new JConflictList(true));
                this.addFacet(fn);
                this.created.add(fn);
                this.addConflicts(hE.getiFace(), hE.getTwin().getiFace(), fn);
                fn.link(hE);
                if (last != null) {
                    fn.link(last, next, hE.getOrigin());
                }
                last = fn;
                if (first != null) continue;
                first = fn;
            }
            if (first != null && last != null) {
                last.link(first, next, this.horizon.get(0).getOrigin());
            }
            if (this.created.size() == 0) continue;
            for (JFace f : this.visible) {
                this.removeConflict(f);
            }
            ++this.current;
            this.created.clear();
        }
        return this.facets;
    }

    private void addConflicts(JFace old1, JFace old2, JFace fn) {
        JVertex v1;
        ArrayList<JVertex> l1 = new ArrayList<JVertex>();
        old1.getList().getVertices(l1);
        ArrayList<JVertex> l2 = new ArrayList<JVertex>();
        old2.getList().getVertices(l2);
        ArrayList<JVertex> nCL = new ArrayList<JVertex>();
        int l = 0;
        int i = 0;
        while (i < l1.size() || l < l2.size()) {
            if (i < l1.size() && l < l2.size()) {
                v1 = (JVertex)l1.get(i);
                JVertex v2 = (JVertex)l2.get(l);
                if (v1.getIndex() == v2.getIndex()) {
                    nCL.add(v1);
                    ++i;
                    ++l;
                    continue;
                }
                if (v1.getIndex() > v2.getIndex()) {
                    nCL.add(v1);
                    ++i;
                    continue;
                }
                nCL.add(v2);
                ++l;
                continue;
            }
            if (i < l1.size()) {
                nCL.add((JVertex)l1.get(i++));
                continue;
            }
            nCL.add((JVertex)l2.get(l++));
        }
        for (i = nCL.size() - 1; i >= 0; --i) {
            v1 = (JVertex)nCL.get(i);
            if (!fn.conflict(v1)) continue;
            this.addConflict(fn, v1);
        }
    }

    private void removeConflict(JFace f) {
        f.removeConflict();
        int index = f.getIndex();
        f.setIndex(-1);
        if (index == this.facets.size() - 1) {
            this.facets.remove(this.facets.size() - 1);
            return;
        }
        if (index >= this.facets.size() || index < 0) {
            return;
        }
        JFace last = this.facets.remove(this.facets.size() - 1);
        last.setIndex(index);
        this.facets.set(index, last);
    }

    private void prep() {
        int i;
        if (this.points.size() <= 3) {
            throw new NotEnoughPointsException();
        }
        if (this.permutate) {
            this.permutation();
        }
        for (int i2 = 0; i2 < this.points.size(); ++i2) {
            this.points.get(i2).setIndex(i2);
        }
        JVertex v0 = this.points.get(0);
        JVertex v1 = this.points.get(1);
        JVertex v3 = null;
        JVertex v2 = null;
        for (i = 2; i < this.points.size(); ++i) {
            if (v0.linearDependent(this.points.get(i)) && v1.linearDependent(this.points.get(i))) continue;
            v2 = this.points.get(i);
            v2.setIndex(2);
            this.points.get(2).setIndex(i);
            this.points.set(i, this.points.get(2));
            this.points.set(2, v2);
            break;
        }
        if (v2 == null) {
            throw new NotEnoughPointsException("Not enough non-planar Points");
        }
        JFace f0 = new JFace(v0, v1, v2);
        for (i = 3; i < this.points.size(); ++i) {
            if (f0.getNormal().dot(f0.getVertex(0)) == f0.getNormal().dot(this.points.get(i))) continue;
            v3 = this.points.get(i);
            v3.setIndex(3);
            this.points.get(3).setIndex(i);
            this.points.set(i, this.points.get(3));
            this.points.set(3, v3);
            break;
        }
        if (v3 == null) {
            throw new NotEnoughPointsException("Not enough non-planar Points");
        }
        f0.orient(v3);
        JFace f1 = new JFace(v0, v2, v3, v1);
        JFace f2 = new JFace(v0, v1, v3, v2);
        JFace f3 = new JFace(v1, v2, v3, v0);
        this.addFacet(f0);
        this.addFacet(f1);
        this.addFacet(f2);
        this.addFacet(f3);
        f0.link(f1, v0, v2);
        f0.link(f2, v0, v1);
        f0.link(f3, v1, v2);
        f1.link(f2, v0, v3);
        f1.link(f3, v2, v3);
        f2.link(f3, v3, v1);
        for (int i3 = this.current = 4; i3 < this.points.size(); ++i3) {
            JVertex v = this.points.get(i3);
            if (f0.conflict(v)) {
                this.addConflict(f0, v);
            }
            if (f1.conflict(v)) {
                this.addConflict(f1, v);
            }
            if (f2.conflict(v)) {
                this.addConflict(f2, v);
            }
            if (!f3.conflict(v)) continue;
            this.addConflict(f3, v);
        }
    }

    private void permutation() {
        int pointSize = this.points.size();
        for (int i = pointSize - 1; i > 0; --i) {
            int ra = this.rand.nextInt(i);
            JVertex temp = this.points.get(ra);
            temp.setIndex(i);
            JVertex currentItem = this.points.get(i);
            currentItem.setIndex(ra);
            this.points.set(ra, currentItem);
            this.points.set(i, temp);
        }
    }

    private void addFacet(JFace f0) {
        f0.setIndex(this.facets.size());
        this.facets.add(f0);
    }

    private void addConflict(JFace f0, JVertex v) {
        JGraphEdge e = new JGraphEdge(f0, v);
        f0.getList().add(e);
        v.getList().add(e);
    }

    public int getVertexCount() {
        return this.points.size();
    }

    public JVertex getVertex(int i) {
        return this.points.get(i);
    }

    public int getFacetCount() {
        return this.facets.size();
    }

    public JFace getFacet(int i) {
        return this.facets.get(i);
    }

    private boolean isPermutate() {
        return this.permutate;
    }

    private void setPermutate(boolean permutate) {
        this.permutate = permutate;
    }
}

