/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.originalfastvoronoi.pd.gui;

import com.treemap.swing.crossplatform.ShapeShape;
import com.treemap.swing.originalfastvoronoi.datastructure.OpenList;
import com.treemap.swing.originalfastvoronoi.j2d.Point2D;
import com.treemap.swing.originalfastvoronoi.j2d.PolygonSimple;
import com.treemap.swing.originalfastvoronoi.j2d.Site;
import com.treemap.swing.originalfastvoronoi.pd.PowerDiagram;
import com.treemap.swing.originalfastvoronoi.pd.gui.JSite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class PowerBox
extends JFrame {
    ArrayList<JSite> points = new ArrayList();
    OpenList sites = new OpenList();
    PolygonSimple clipPoly = new PolygonSimple();
    HashMap<Point2D.Double, HashSet<Site>> vertices = new HashMap();
    public static PowerBox powerBox = null;
    JPanel panel = new JPanel();

    public PowerBox() {
        this.clipPoly.add(50.0, 50.0);
        this.clipPoly.add(50.0, 800.0);
        this.clipPoly.add(800.0, 800.0);
        this.clipPoly.add(800.0, 50.0);
        powerBox = this;
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().setBackground(Color.BLACK);
        this.getContentPane().add(this.panel);
        this.panel.setVisible(true);
        this.panel.setLayout(null);
        this.panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
            }

            @Override
            public synchronized void mouseClicked(MouseEvent e) {
                Point p = e.getPoint();
                double weight = 30.0;
                Site site = new Site(p.getX(), p.getY(), weight);
                PowerBox.this.sites.add(site);
                JSite jsite = new JSite(site);
                PowerBox.this.panel.add(jsite);
                jsite.setVisible(true);
                PowerBox.this.points.add(jsite);
                if (PowerBox.this.points.size() > 1) {
                    // empty if block
                }
                powerBox.computeDiagram();
                PowerBox.this.repaint();
                PowerBox.this.resize(PowerBox.this.getSize());
                PowerBox.this.repaint();
            }
        });
        this.setVisible(true);
        this.setSize(500, 400);
    }

    public void computeDiagram() {
        PowerDiagram diagram = new PowerDiagram(this.sites, this.clipPoly);
        diagram.computeDiagram();
        for (JSite component : this.points) {
            component.setPolygon(component.getSite().getPolygon());
        }
        this.repaint();
        this.resize(this.getSize());
    }

    public static void main(String[] args) {
        new PowerBox();
    }

    @Override
    public void paint(Graphics g2) {
        int z;
        super.paint(g2);
        Graphics2D g = (Graphics2D)g2;
        g2.translate(2, 22);
        g.setColor(Color.red);
        Site[] array = this.sites.array;
        int size = this.sites.size;
        g2.setColor(Color.green);
        for (int z2 = 0; z2 < size; ++z2) {
            Site s = array[z2];
            double posX = s.getX();
            double posY = s.getY();
            double radius = Math.sqrt(s.getWeight());
            g.drawOval((int)posX - (int)radius, (int)posY - (int)radius, (int)(2.0 * radius), (int)(2.0 * radius));
            int r2 = 5;
            Color normal = g.getColor();
            if (s.getPolygon() == null) {
                g.setColor(Color.red);
            }
            g.drawRect((int)posX - r2, (int)posY - r2, 2 * r2, 2 * r2);
            g.setColor(normal);
        }
        int i = 0;
        for (z = 0; z < size; ++z) {
            g.setColor(Color.GRAY.brighter());
            Site s = array[z];
            if (i != -2) {
                PolygonSimple poly = s.getPolygon();
                if (poly != null) {
                    g.draw(new ShapeShape(poly));
                }
                s.paint(g);
            }
            ++i;
        }
        for (z = 0; z < size; ++z) {
            Site s = array[z];
            double posX = s.getX();
            double posY = s.getY();
            double radius = Math.sqrt(s.getWeight());
            g.drawOval((int)posX - (int)radius, (int)posY - (int)radius, (int)(2.0 * radius), (int)(2.0 * radius));
            int r2 = 7;
            g.drawRect((int)posX - r2, (int)posY - r2, 2 * r2, 2 * r2);
            PolygonSimple poly = s.getPolygon();
            if (poly == null) continue;
            Point2D center = poly.getCentroid();
            r2 = 5;
            g.setColor(Color.blue);
            g.drawRect((int)center.getX() - r2, (int)center.getY() - r2, 2 * r2, 2 * r2);
        }
        this.validate();
    }
}

